% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rscripts.R
\name{po_gl}
\alias{po_gl}
\title{Generate genotype likelihoods from offspring genotypes.}
\usage{
po_gl(
  genovec,
  ploidy,
  p1_geno = NULL,
  p2_geno = NULL,
  rd = 10,
  seq = 0.01,
  bias = 1,
  od = 0.01
)
}
\arguments{
\item{genovec}{Offspring genotypes. \code{genovec[i]} is the dosage for individual i.}

\item{ploidy}{Ploidy}

\item{p1_geno}{Parent 1 genotype}

\item{p2_geno}{Parent 2 genotype}

\item{rd}{Read depth. Lower is more uncertain.}

\item{seq}{Sequencing error rate. Higher means more uncertain.}

\item{bias}{Bias. 1 means no bias.}

\item{od}{Overdispersion. Typical value is like 0.01. Higher means more uncertain.}
}
\value{
Genotype likelihoods
}
\description{
Takes as input (i) the parent genotypes,
(ii) the offspring genotype frequency, (iii) sequencing error rate, (iv) read
depth, (v) bias, and (vi) overdispersion. It returns genotype likelihoods.
}
\examples{
set.seed(1)
po_gl(genovec = c(1, 2, 1, 1, 3), p1_geno = 2, p2_geno = 2, ploidy = 4)

}
\author{
Mira Thakkar
}
