% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rvest.R
\name{read_html.selenider_session}
\alias{read_html.selenider_session}
\alias{read_html.selenider_element}
\title{Read a live HTML document}
\usage{
read_html.selenider_session(
  x,
  encoding = "",
  ...,
  options = c("RECOVER", "NOERROR", "NOBLANKS")
)

read_html.selenider_element(
  x,
  encoding = "",
  timeout = NULL,
  outer = TRUE,
  ...,
  options = c("RECOVER", "NOERROR", "NOBLANKS")
)
}
\arguments{
\item{x}{A \code{selenider_session}/\code{selenider_element} object.}

\item{encoding, ..., options}{Passed into \code{\link[xml2:read_xml]{xml2::read_html()}}.}

\item{timeout}{How long to wait for \code{x} to exist in the DOM before throwing
an error.}

\item{outer}{Whether to read the inner (all children of the current element)
or outer (including the element itself) HTML of \code{x}.}
}
\value{
\code{read_html()} returns an XML document. Note that HTML will always be wrapped
in a \verb{<html>} and \verb{<body>} tag, if it isn't already.
}
\description{
\code{\link[xml2:read_xml]{xml2::read_html()}} can be used on a selenider session to read the HTML of
the entire page, or on a selenider element to get the HTML of that element.
}
\examples{
\dontshow{if (selenider::selenider_available(online = FALSE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(rvest)

html <- "
<div>
<p>Example text</p>
</div>
"

session <- minimal_selenider_session(html)

read_html(session)
read_html(s("div"))
\dontshow{\}) # examplesIf}
}
