% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{actions_stream}
\alias{actions_stream}
\title{Create a set of actions to be performed}
\usage{
actions_stream(...)
}
\arguments{
\item{...}{\code{selenium_action} objects: the actions to perform.}
}
\value{
A \code{selenium_actions_stream} object, ready to be passed into
\code{SeleniumSession$perform_actions()}.
}
\description{
\code{actions_stream()} creates a set of actions to be performed by
\code{SeleniumSession$perform_actions()}. Actions are a low level way to interact
with a page.
}
\examples{
actions_stream(
  actions_press(keys$enter),
  actions_pause(0.5),
  actions_release(keys$enter),
  actions_scroll(x = 1, y = 1, delta_x = 1, delta_y = 1, duration = 0.5),
  actions_mousemove(x = 1, y = 1, duration = 1, origin = "pointer")
)

}
\seealso{
\itemize{
\item Pause actions: \code{\link[=actions_pause]{actions_pause()}}.
\item Press actions: \code{\link[=actions_press]{actions_press()}} and \code{\link[=actions_release]{actions_release()}}.
\item Mouse actions: \code{\link[=actions_mousedown]{actions_mousedown()}}, \code{\link[=actions_mouseup]{actions_mouseup()}}
and \code{\link[=actions_mousemove]{actions_mousemove()}}.
\item Scroll actions: \code{\link[=actions_scroll]{actions_scroll()}}.
}
}
