% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implied_scores.R
\name{implied_scores}
\alias{implied_scores}
\title{Implied Scores of Observed Outcome Variables}
\usage{
implied_scores(fit, output = "matrix", skip_all_checks = FALSE)
}
\arguments{
\item{fit}{The output from \code{\link[lavaan:lavaan]{lavaan::lavaan()}}, such as \code{\link[lavaan:cfa]{lavaan::cfa()}}
and \code{\link[lavaan:sem]{lavaan::sem()}}.}

\item{output}{Output type. If \code{"matrix"}, the default,
the output will be combined to one matrix, with cases ordered as
in the original dataset (after listwise deletion, if used). If
\code{"list"}, the a list of matrices is returned, even if the model
has only one group.}

\item{skip_all_checks}{If \code{TRUE}, skips all checks and allows
users to run this function on any object of \code{lavaan} class.
For users to experiment this and other functions on models
not officially supported. Default is \code{FALSE}.}
}
\value{
A matrix of the implied scores if \code{output} is \code{"matrix"}.
If \code{output} is \code{"list"}, a list of matrices of the implied scores.
}
\description{
Gets a \code{\link[lavaan:lavaan]{lavaan::lavaan()}} output and computes the
implied scores of observed outcome variables.
}
\details{
The implied scores for each observed outcome variable
(the \code{y}-variables or the endogenous variables) are
simply computed in the same way the predicted scores in a linear
regression model are computed.

Currently it supports only single-group and multiple-group
path analysis models with only
observed variables.
(Support for multiple-group models available in 0.1.4.8 and later version).
}
\examples{
library(lavaan)
dat <- pa_dat
# For illustration, select only the first 50 cases
dat <- dat[1:50, ]
# The model
mod <-
"
m1 ~ iv1 + iv2
dv ~ m1
"
# Fit the model
fit <- lavaan::sem(mod, dat)
summary(fit)

# Compute the implied scores for `m1` and `dv`
fit_implied_scores <- implied_scores(fit)
head(fit_implied_scores)


}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}.
}
