% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quickplots.R
\name{quick_sem_plot}
\alias{quick_sem_plot}
\alias{quick_parallel_mediation}
\alias{q_parallel}
\alias{quick_serial_mediation}
\alias{q_serial}
\alias{quick_simple_mediation}
\alias{q_simple}
\title{Quick Plots of Common Models}
\usage{
quick_parallel_mediation(
  object,
  x,
  m,
  y,
  mediators_position = c("center", "top", "bottom"),
  what = "path",
  whatLabels = "est",
  style = c("lisrel", "ram"),
  nCharNodes = 0,
  nCharEdges = 0,
  sizeMan = NULL,
  sizeLat = NULL,
  edge.label.cex = NULL,
  intercepts = FALSE,
  ...,
  plot_now = TRUE,
  do_mark_se = TRUE,
  do_mark_sig = TRUE,
  do_rotate_resid = TRUE,
  do_add_rsq = TRUE,
  add_notes = FALSE,
  notes = NULL
)

q_parallel(
  object,
  x,
  m,
  y,
  mediators_position = c("center", "top", "bottom"),
  what = "path",
  whatLabels = "est",
  style = c("lisrel", "ram"),
  nCharNodes = 0,
  nCharEdges = 0,
  sizeMan = NULL,
  sizeLat = NULL,
  edge.label.cex = NULL,
  intercepts = FALSE,
  ...,
  plot_now = TRUE,
  do_mark_se = TRUE,
  do_mark_sig = TRUE,
  do_rotate_resid = TRUE,
  do_add_rsq = TRUE,
  add_notes = FALSE,
  notes = NULL
)

quick_serial_mediation(
  object,
  x,
  m,
  y,
  mediators_position = c("top", "bottom"),
  what = "path",
  whatLabels = "est",
  style = c("lisrel", "ram"),
  nCharNodes = 0,
  nCharEdges = 0,
  sizeMan = NULL,
  sizeLat = NULL,
  edge.label.cex = NULL,
  intercepts = FALSE,
  ...,
  plot_now = TRUE,
  do_mark_se = TRUE,
  do_mark_sig = TRUE,
  do_rotate_resid = TRUE,
  do_add_rsq = TRUE,
  add_notes = FALSE,
  notes = NULL
)

q_serial(
  object,
  x,
  m,
  y,
  mediators_position = c("top", "bottom"),
  what = "path",
  whatLabels = "est",
  style = c("lisrel", "ram"),
  nCharNodes = 0,
  nCharEdges = 0,
  sizeMan = NULL,
  sizeLat = NULL,
  edge.label.cex = NULL,
  intercepts = FALSE,
  ...,
  plot_now = TRUE,
  do_mark_se = TRUE,
  do_mark_sig = TRUE,
  do_rotate_resid = TRUE,
  do_add_rsq = TRUE,
  add_notes = FALSE,
  notes = NULL
)

quick_simple_mediation(
  object,
  x,
  m,
  y,
  mediators_position = c("top", "bottom"),
  what = "path",
  whatLabels = "est",
  style = c("lisrel", "ram"),
  nCharNodes = 0,
  nCharEdges = 0,
  sizeMan = NULL,
  sizeLat = NULL,
  edge.label.cex = NULL,
  intercepts = FALSE,
  ...,
  plot_now = TRUE,
  do_mark_se = TRUE,
  do_mark_sig = TRUE,
  do_rotate_resid = TRUE,
  do_add_rsq = TRUE,
  add_notes = FALSE,
  notes = NULL
)

q_simple(
  object,
  x,
  m,
  y,
  mediators_position = c("top", "bottom"),
  what = "path",
  whatLabels = "est",
  style = c("lisrel", "ram"),
  nCharNodes = 0,
  nCharEdges = 0,
  sizeMan = NULL,
  sizeLat = NULL,
  edge.label.cex = NULL,
  intercepts = FALSE,
  ...,
  plot_now = TRUE,
  do_mark_se = TRUE,
  do_mark_sig = TRUE,
  do_rotate_resid = TRUE,
  do_add_rsq = TRUE,
  add_notes = FALSE,
  notes = NULL
)
}
\arguments{
\item{object}{A \code{lavaan} object, such
as the output of \code{\link[lavaan:sem]{lavaan::sem()}}.}

\item{x}{The name of the \code{x} variable.
Must have exactly one \code{x} variable.}

\item{m}{The name(s) of the \code{m}
variable(s). The allowed number of \code{m}
variable(s) depends of the model to
be drawn.}

\item{y}{The name of the \code{y} variable.
Must have exactly one \code{y} variable.}

\item{mediators_position}{For a
simple mediation model, it can be
either \code{"top"} or \code{"bottom"}. For
a parallel or serial mediation model,
it can be \code{"top"}, \code{"bottom"}, or
\code{"center"}.}

\item{what}{The same argument of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. What the edges
(arrows) denote. Default is \code{"path"},
the paths drawn with equal width.}

\item{whatLabels}{The same argument
of \code{\link[semPlot:semPaths]{semPlot::semPaths()}}. What the
edge labels represent. Default is
\code{"est"}, the parameter estimates.
Can be set to \code{"std"} to print
standardized coefficients.}

\item{style}{The same argument of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. How residual
variances are drawn. Can be \code{"lisrel"},
the default, or \code{"ram"}.}

\item{nCharNodes}{The same argument of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. Default is 0,
to disable abbreviation of the variable
names.}

\item{nCharEdges}{The same argument of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. Default is 0,
to disable abbreviation of the edge
labels.}

\item{sizeMan}{The same argument of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. The size
of the observed variables. Default is
\code{NULL} and the actual size determined
internally based on the number of
mediators.}

\item{sizeLat}{The same argument of
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. The size
of the latent variables. Default is
\code{NULL} and the actual size determined
internally based on the number of
mediators.}

\item{edge.label.cex}{The same
argument of \code{\link[semPlot:semPaths]{semPlot::semPaths()}}.
The size of the edge labels
(parameter estimates). Default is
\code{NULL} and the actual size determined
internally based on the number of
mediators.}

\item{intercepts}{The same
argument of \code{\link[semPlot:semPaths]{semPlot::semPaths()}},
determining whether intercepts will
be plotted. Default is
\code{FALSE}, different from
\code{\link[semPlot:semPaths]{semPlot::semPaths()}}. It should not
be set to \code{TRUE}, but included as
an argument for possible features
to be added in the future.}

\item{...}{Other arguments to be
passed to to \code{\link[semPlot:semPaths]{semPlot::semPaths()}}.}

\item{plot_now}{Logical. If \code{TRUE},
the default, the plot will be plotted
immediately. Set it to \code{FALSE} if the
plot will be further processed before
being plotted.}

\item{do_mark_se}{Logical. If \code{TRUE},
the default, standard errors will be
added by \code{\link[=mark_se]{mark_se()}}. The \code{lavaan}
standard errors will be used if the
standardized coefficients are requested
(\code{whatLabels} set to \code{std}).}

\item{do_mark_sig}{Logical. If
\code{TRUE}, the default, significance
test results will be marked by
asterisks using \code{\link[=mark_sig]{mark_sig()}}.}

\item{do_rotate_resid}{Logical. If
\code{TRUE}, the default, Error variances,
or R-squares if \code{do_add_rsq} is \code{TRUE},
will be rotated based on the layout.}

\item{do_add_rsq}{Logical. If
\code{TRUE}, the default, Error variances
will be replaced by R-squares, added
by \code{\link[=add_rsq]{add_rsq()}}.}

\item{add_notes}{Logical. If
\code{TRUE} and \code{plot_now} is also \code{TRUE},
a note will be added by \code{\link[=text]{text()}},
using \code{notes}. Customization is limited.
Do not use for now. Commonly used
notes will be added in the future.}

\item{notes}{A string, the notes to
be printed if \code{add_notes} is \code{TRUE}.}
}
\value{
A \link[qgraph:qgraph]{qgraph::qgraph} generated
by \code{\link[semPlot:semPaths]{semPlot::semPaths()}} and
customized by other \code{semptools}
functions is returned invisibly.
Called for its side effect.
}
\description{
Simple-to-use functions
for generating plots of common models.
}
\details{
A collection of functions for
generating the plots of common
models. They are designed to need as
few arguments as possible to have a
plot that should need minimal
postprocessing.

Currently, functions are available
for these plots:
\itemize{
\item Simple mediation models (a model
with only one mediator):
\code{\link[=q_simple]{q_simple()}} or
\code{\link[=quick_simple_mediation]{quick_simple_mediation()}}.
\item Parallel mediation models (a model
with one or more paths between two
variables, each path with only one
mediator): \code{\link[=q_parallel]{q_parallel()}} or
\code{\link[=quick_parallel_mediation]{quick_parallel_mediation()}}.
\item Serial mediation models (a model
with one main path between two
variables, withe one or more
mediators along the path):
\code{\link[=q_serial]{q_serial()}} or
\code{\link[=quick_serial_mediation]{quick_serial_mediation()}}.
}

For these three functions, if the
default settings are desired, users
only need to supply the \code{lavaan}
output, and specify:
\itemize{
\item The \code{x} variable (predictor) to
be included.
\item The \code{m} variable(s) to be included,
which is a character vector if the
model has more than one mediator.
\item The \code{y} variable to be included.
}

These variables can be observed
variables or latent factors. Indicators
of latent variables will not be drawn
(unless they are listed in \code{x},
\code{m}, or \code{y}).

The layout is determined by the
argument \code{mediators_position}, with
two or more preset layouts for each
model.

By default, the following will be
added to the plot:
\itemize{
\item Asterisks included to denote the
significance test results
(implemented by \code{\link[=mark_sig]{mark_sig()}}).
\item Standard errors included for free
parameters (implemented by
\code{\link[=mark_se]{mark_se()}}).
\item R-squares are drawn in place of
error variances for the \code{m}
variable(s) and \code{y} variable
(implemented by \code{\link[=add_rsq]{add_rsq()}}).
}

These options can be turned off if
so desired.

Unlike other function in \code{semptools},
these functions are usually used to
plot a model immediately. Therefore,
the resulting plot will be plotted by
default. Turned this off by setting
\code{plot_now} to \code{FALSE} (analogous to
setting \code{DoNotPlot} to \code{FALSE} when
calling \code{\link[semPlot:semPaths]{semPlot::semPaths()}}).

Although the plot is designed to be
ready-to-plot, it can be further
processed by other \code{semptools}
functions if necessary, just like the
plot of \code{\link[semPlot:semPaths]{semPlot::semPaths()}}.
\subsection{Variables to be drawn}{

For readability, it is common for
researchers to omit some variables
when drawing a model.

For example:

\code{m ~ x + c1 + c2}

\code{y ~ m + x + c1 + c2}

If \code{c1} and \code{c2} are control variables,
researchers want to draw only these\
paths

\code{m ~ x}

\code{y ~ m + x}

The quick plot functions can be used
for this purpose. Only selected
variables will be included in the
plots.

Researchers may also want to draw
several plots, one for each pair of
the predictor (the \code{x}-variable) and
the outcome variable (the
\code{y}-variable).

For example,

\code{m ~ x + c1 + c2}

\code{y1 ~ m + x + c1 + c2}

\code{y2 ~ m + x + c1 + c2}

For this model, in addition to
excluding the control variables,
researchers may want to generate two
diagrams, one for \code{y1}:

\code{m ~ x}

\code{y1 ~ m + x}

and the other for \code{y2}:

\code{m ~ x}

\code{y2 ~ m + x}

Note that all the functions will not
check the models. The specification
of \code{x}, \code{m}, and \code{y} are assumed to
be valid for the fitted models.
}
}
\examples{

library(lavaan)
library(semPlot)

# ---- Parallel Mediation Model

mod_parallel <-
 'x04 ~ x01
  x05 ~ x01
  x06 ~ x01
  x07 ~ x01
  x10 ~ x04 + x05 + x06 + x07 + x01'

fit_parallel <- lavaan::sem(mod_parallel,
                            sem_example)

q_parallel(fit_parallel,
           x = "x01",
           m = c("x04", "x05", "x06", "x07"),
           y = "x10")

q_parallel(fit_parallel,
           x = "x01",
           m = c("x04", "x05", "x06", "x07"),
           y = "x10",
           mediators_position = "top")

q_parallel(fit_parallel,
           x = "x01",
           m = c("x04", "x05", "x06", "x07"),
           y = "x10",
           mediators_position = "bottom")

# Suppress some elements for readability

q_parallel(fit_parallel,
           x = "x01",
           m = c("x04", "x05", "x06", "x07"),
           y = "x10",
           mediators_position = "bottom",
           do_mark_se = FALSE)

# ---- Serial Mediation Model

mod_serial <-
 'x04 ~ x01
  x05 ~ x04 + x01
  x06 ~ x04 + x05 + x01
  x07 ~ x04 + x05 + x06 + x01
  x08 ~ x04 + x05 + x06 + x07 + x01'
fit_serial <- lavaan::sem(mod_serial,
                          sem_example)
q_serial(fit_serial,
         x = "x01",
         m = c("x04", "x05", "x06", "x07"),
         y = "x08")

q_serial(fit_serial,
         x = "x01",
         m = c("x04", "x05", "x06", "x07"),
         y = "x08",
         mediators_position = "bottom")

# Suppress some elements for readability

q_serial(fit_serial,
         x = "x01",
         m = c("x04", "x05", "x06", "x07"),
         y = "x08",
         mediators_position = "bottom",
         do_mark_se = FALSE)

# ---- Simple Mediation Model: With Control Variables

mod_pa <-
'x3 ~  x1 + x2
 x4 ~  x3 + x1 + x2'
fit_pa <- lavaan::sem(mod_pa,
                      pa_example)

mod_sem <-
'f1 =~ x01 + x02 + x03
 f2 =~ x04 + x05 + x06 + x07
 f3 =~ x08 + x09 + x10
 f4 =~ x11 + x12 + x13 + x14
 f3 ~  f1 + f2
 f4 ~  f1 + f3'
fit_sem <- lavaan::sem(mod_sem,
                       sem_example)
q_simple(fit_pa,
         x = "x1",
         m = "x3",
         y = "x4")

# Drawing latent factors only

q_simple(fit_sem,
         x = "f1",
         m = "f3",
         y = "f4",
         whatLabels = "std",
         mediators_position = "bottom")

}
