% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_functions.R
\name{run_benchmarking}
\alias{run_benchmarking}
\title{Run Formal Benchmarking}
\usage{
run_benchmarking(
  estimate,
  RV,
  formula = NULL,
  weights = NULL,
  pop_svy = NULL,
  sample_svy = NULL,
  Y = NULL,
  weighting_vars = NULL,
  benchmark_vars = "all",
  data = NULL,
  treatment = NULL,
  outcome = NULL,
  selection = NULL,
  population_targets = NULL,
  weighting_method = "ebal",
  weight_max = Inf,
  sigma2 = NULL,
  estimand = "ATT"
)
}
\arguments{
\item{estimate}{Weighted estimate}

\item{RV}{Robustness Value}

\item{formula}{Raking formula for survey estimand}

\item{weights}{A vector, containing the estimated survey weights}

\item{pop_svy}{Survey object, containing the population the survey sample is being re-weighted to}

\item{sample_svy}{Survey object, containing the survey sample being re-weighted}

\item{Y}{outcome of interest (used for survey object)}

\item{weighting_vars}{Vector of variables to use in the weights estimation for ATT or PATE}

\item{benchmark_vars}{Vector of variables to benchmark parameters for. If \code{benchmark_vars = 'all'}, benchmarking will be run across all variables included in the weights. If not set to \code{all}, benchmarking will be conducted across the covariates included in the vector.}

\item{data}{A data.frame containing the observed covariates included in the weights; must include variables specified in weighting_vars}

\item{treatment}{Denotes which variable is the treatment variable}

\item{outcome}{Denotes which variable is the outcome variable}

\item{selection}{Denotes which variable is the selection variable}

\item{population_targets}{Population targets for the raking formula in surveys (optional, if not provided, will be generated from pop_svy)}

\item{weighting_method}{Weighting method. Supports weighting methods from the package \code{WeightIt}.}

\item{weight_max}{Maximum weight to trim at. Default set to \code{Inf}.}

\item{sigma2}{If \code{estimand = "PATE"}, \code{sigma2} must specify the bound on treatment effect heterogeneity. For the other two estimands, the function will automatically calculate the sample variance across the control units, or the survey sample.}

\item{estimand}{Specifies estimand; possible parameters include "ATT", "PATE", or "Survey"}
}
\value{
data.frame containing the benchmarked parameter values, the estimated bias, MRCS, and minimum \code{k_sigma} and \code{k_rho} values for a killer confounder for the set of pre-specified covariates.
}
\description{
Wrapper function to run formal benchmarking on a set of pre-specified covariates. Returns a data.frame containing the benchmarked parameter values, the estimated bias, MRCS, and minimum \code{k_sigma} and \code{k_rho} values for a killer confounder.
}
\examples{
# For the external validity setting: 
data(jtpa_women)
site_name <- "NE"
df_site <- jtpa_women[which(jtpa_women$site == site_name), ]
df_else <- jtpa_women[which(jtpa_women$site != site_name), ]

# Estimate unweighted estimator:
model_dim <- estimatr::lm_robust(Y ~ T, data = df_site)
PATE <- coef(lm(Y ~ T, data = df_else))[2]
DiM <- coef(model_dim)[2]
# Generate weights using observed covariates:
df_all <- jtpa_women
df_all$S <- ifelse(jtpa_women$site == "NE", 1, 0)
model_ps <- WeightIt::weightit(
  (1 - S) ~ . - site - T - Y, 
  data = df_all, method = "ebal", estimand = "ATT"
)
weights <- model_ps$weights[df_all$S == 1]
# Estimate IPW model:
model_ipw <- estimatr::lm_robust(Y ~ T, data = df_site, weights = weights)
ipw <- coef(model_ipw)[2]
# Estimate bound for var(tau):
vartau <- var(df_site$Y[df_site$T == 1]) - var(df_site$Y[df_site$T == 0])
RV <- robustness_value(estimate = ipw, b_star = 0, sigma2 = vartau, weights = weights)

# Select weighting variables:
weighting_vars <- names(df_all)[which(!names(df_all) \%in\% c("site", "S", "Y", "T"))]

# Run benchmarking:
df_benchmark <- run_benchmarking(
  weighting_vars = weighting_vars,
  data = df_all[, -1],
  treatment = "T", outcome = "Y", selection = "S",
  estimate = ipw,
  RV = RV, sigma2 = vartau,
  estimand = "PATE"
)

print(df_benchmark)

}
