% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{applyDisto}
\alias{applyDisto}
\title{Distortion effect}
\usage{
applyDisto(sample, type = c("clip", "tanh"), level = 2, ..., rescale = FALSE)
}
\arguments{
\item{sample}{soundSample object, input sample}

\item{type}{Character string, the distortion type}

\item{level}{Numeric >0, distortion level}

\item{...}{other parameters passed to the distortion transfer function}

\item{rescale}{Logical. If TRUE, the soundSample wave is rescaled to [-1,1]}
}
\value{
The distorted sound sample
}
\description{
Apply a distortion to a sound sample
}
\examples{
# example code
raw=oscillator(freq=110,duration=0.5)
plot(raw)
dist=applyDisto(raw,type='tanh',level=5)
plot(dist)
}
