% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-exports-utils.R
\name{prepare_items_for_bulk_export}
\alias{prepare_items_for_bulk_export}
\title{Prepare items for bulk export}
\usage{
prepare_items_for_bulk_export(
  files,
  destination_volume,
  destination_location_prefix = NULL,
  overwrite = TRUE,
  properties = NULL
)
}
\arguments{
\item{files}{A list of \code{\link{File}} objects or list of strings
(IDs) of the files you are about to export to a volume.}

\item{destination_volume}{Either a \code{\link{Volume}} object or the ID of
the volume to which the file will be exported.}

\item{destination_location_prefix}{Character. If the volume has been
configured with a prefix parameter, \cr
\code{destination_location_prefix} value will be prepended to location before
attempting to create the file on the volume. This parameter can be treated
as a path to a new file on the volume. The default value is \code{NULL}.

If you would like to export the file into a folder on the volume,
please add folder name as the prefix before the file name in the
\code{"<folder-name>/"} form. Remember to put a slash character ("/") at the end
of the string.

Keep in mind that the same prefix will be added to all items (files) in the
resulting list.}

\item{overwrite}{Logical. If this is set to \code{TRUE} and a named file exists
in the project where the alias is about to be created, the existing file
will be deleted. \code{FALSE} by default.

Keep in mind that the same overwrite option will be applied to all items
(files) in the resulting list.}

\item{properties}{Named list of additional volume properties, like:
\itemize{
\item \code{sse_algorithm} - S3 server-side encryption to use when
exporting to this bucket. Supported values:
\code{AES256} (SSE-S3 encryption), \code{aws:kms}, \code{null}
(no server-side encryption). Default: \code{AES256}.
\item \code{sse_aws_kms_key_Id}: Applies to type: \code{s3}.
If AWS KMS encryption is used, this should be set to the required
KMS key. If not set and \code{aws:kms} is set as \code{sse_algorithm},
default KMS key is used.
\item \code{aws_canned_acl}: S3 canned ACL to apply on the object
during export. Supported values: any one of
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/acl-overview.html#canned-acl}{S3 canned ACLs};
\code{null} (do not apply canned ACLs). Default: \code{null}.
}

Keep in mind that the same properties will be applied to all items (files)
in the resulting list.}
}
\value{
List of body params items for starting an export job.
}
\description{
Utility function to prepare the \code{items} parameter, a list of
elements containing information about each file to be exported using the
\code{bulk_submit_export()} method.
}
\details{
Based on the provided list of \code{\link{File}} objects or
file IDs, this function allows you to set the following fields for each
item:
\itemize{
\item \code{source_file}
\item \code{destination_volume}
\item \code{destination_location}
\item \code{overwrite}
\item \code{properties}
}

However, keep in mind that there are certain constraints:
\itemize{
\item The same \code{destination_volume} applies to all items in the
resulting list.
\item The same applies to \code{overwrite} and \code{properties}
parameters.
\item By default, the \code{destination_location} field is populated with
the source file name. Upon retrieval of the list of items for bulk
export, you can manually update the \cr
\code{destination_location} field for each element of the list as needed.
Additionally, you have the flexibility to manually modify any other
fields in the list if required.
}
}
\examples{
\dontrun{
# Example 1: Prepare 3 items for bulk export action
file_object_1 <- a$files$get(id = "file_1_ID")
file_object_2 <- a$files$get(id = "file_2_ID")
file_object_3 <- a$files$get(id = "file_3_ID")

files_to_export <- list(file_object_1, file_object_2, file_object_3)

prepare_items_for_bulk_export(files_to_export,
  destination_volume = "aws_example_volume"
)
}
\dontrun{
# Example 2: Prepare 3 items for bulk export action into some folder
# on the volume - use folder name as prefix before file names
file_object_1 <- a$files$get(id = "file_1_ID")
file_object_2 <- a$files$get(id = "file_2_ID")
file_object_3 <- a$files$get(id = "file_3_ID")

files_to_export <- list(file_object_1, file_object_2, file_object_3)

prepare_items_for_bulk_export(files_to_export,
  destination_volume = "aws_example_volume",
  destination_location_prefix = "example_folder/"
)
}

}
\seealso{
\code{\link{Exports}}, \code{\link{File}}, \code{\link{Volume}}
}
