% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfclust-methods.R
\name{plot.sfclust}
\alias{plot.sfclust}
\title{Plot function for \code{sfclust} objects}
\usage{
\method{plot}{sfclust}(
  x,
  sample = x$clust$id,
  which = 1:3,
  clusters = NULL,
  sort = FALSE,
  legend = FALSE,
  ...
)
}
\arguments{
\item{x}{An \code{sfclust} object containing the clustering results, including the cluster assignments and model parameters.}

\item{sample}{Integer specifying the clustering sample number to summarize. Defaults to the last sample.}

\item{which}{Integer vector indicating which plot to display. Options are:
- 1: Map of regions colored by cluster assignment.
- 2: Functional shapes of the linear predictors for each cluster.
- 3: Traceplot of the log marginal likelihood.}

\item{clusters}{Optional vector specifying which clusters to plot. If \code{NULL}, all clusters are included.}

\item{sort}{Logical value indicating whether clusters should be relabeled based on the number of elements. Default is \code{FALSE}.}

\item{legend}{Logical value indicating whether a legend should be included in the plot. Default is \code{FALSE}.}

\item{...}{Additional arguments passed to the underlying plotting functions.}
}
\value{
A plot displaying the selected subgraphs as specified by \code{which}.
}
\description{
This function visualizes the estimated clusters from an \code{sfclust} object. It can display:
(1) a map of regions colored by their assigned cluster,
(2) the functional shapes of the linear predictors for each cluster,
and (3) a traceplot of the log marginal likelihood.
A conditional legend is added if the number of clusters is less than 10.
}
