% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_force_join_nb.R
\name{st_force_join_nb}
\alias{st_force_join_nb}
\title{Enforce contiguity between pairs of areas}
\usage{
st_force_join_nb(nb, x = NULL, y = NULL, xy_df = NULL)
}
\arguments{
\item{nb}{a neighbourhood `"list"` or `"matrix"`, or an `sf` dataframe with a neighbourhood column called `"nb"`.}

\item{x}{name or number of first area (optional if `xy_df` is provided).}

\item{y}{name or number of second area (optional if `xy_df` is provided).}

\item{xy_df}{(optional) a dataframe with two columns: `x` and `y`, containing the names or numbers of areas to join.}
}
\value{
An amended neighbourhood `"list"`, `"matrix"`, or `sf` dataframe with a neighbourhood column called `"nb"`.
}
\description{
Enforce contiguity between pairs of areas
}
\examples{
# For individual x and y
st_bridges(uk_election,"constituency_name") |>
st_force_join_nb(x = "Gower", y = "Bridgend")

# For multiple x and y pairse") |>
st_bridges(uk_election,"constituency_name") |>
st_force_join_nb(xy_df = data.frame(
x = c("Gower", "Llanelli"),
y = c("Bridgend", "Vale Of Glamorgan")))
}
