% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{split.shapviz}
\alias{split.shapviz}
\title{Splits "shapviz" Object}
\usage{
\method{split}{shapviz}(x, f, ...)
}
\arguments{
\item{x}{Object of class "shapviz".}

\item{f}{Vector used to split feature values and SHAP (interaction) values.
Empty factor levels are dropped.}

\item{...}{Arguments passed to \code{split()}.}
}
\value{
A "mshapviz" object.
}
\description{
Splits "shapviz" object along a vector \code{f} into an object of class "mshapviz".
}
\examples{
\dontrun{
dtrain <- xgboost::xgb.DMatrix(data.matrix(iris[, -1]), label = iris[, 1])
fit <- xgboost::xgb.train(data = dtrain, nrounds = 10, nthread = 1)
sv <- shapviz(fit, X_pred = dtrain, X = iris)
mx <- split(sv, f = iris$Species)
sv_dependence(mx, "Petal.Length")
}
}
\seealso{
\code{\link[=shapviz]{shapviz()}}, \code{\link[=rbind.shapviz]{rbind.shapviz()}}
}
