% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/inputs.R
\name{input}
\alias{input}
\alias{text_input}
\alias{update_text_input}
\alias{numeric_input}
\alias{update_numeric_input}
\alias{date_input}
\alias{update_date_input}
\title{input}
\usage{
text_input(inputId, ..., value = default_value)

update_text_input(session = shiny::getDefaultReactiveDomain(), inputId, ...)

numeric_input(inputId, ..., value = default_value)

update_numeric_input(session = shiny::getDefaultReactiveDomain(), inputId, ...)

date_input(inputId, ..., value = default_value)

update_date_input(session = shiny::getDefaultReactiveDomain(), inputId, ...)
}
\arguments{
\item{inputId}{ID of the component.}

\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI input component.
}
\description{
Input is a component that allows users to enter text. It can be used to get user inputs in forms, search fields, and more.
}
\details{
\itemize{
\item \bold{children}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{variant}. Type: \code{flat OR bordered OR faded OR underlined}. Default: \code{"flat"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{NA}.
\item \bold{label}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{value}. Type: \code{string}. Default: \code{NA}.
\item \bold{defaultValue}. Type: \code{string}. Default: \code{NA}.
\item \bold{placeholder}. Type: \code{string}. Default: \code{NA}.
\item \bold{description}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{errorMessage}. Type: \code{ReactNode OR ((v: ValidationResult) => ReactNode)}. Default: \code{NA}.
\item \bold{validate}. Type: \code{(value: string) => ValidationError OR true OR null OR undefined}. Default: \code{NA}.
\item \bold{validationBehavior}. Type: \code{native OR aria}. Default: \code{"native"}.
\item \bold{minLength}. Type: \code{number}. Default: \code{NA}.
\item \bold{maxLength}. Type: \code{number}. Default: \code{NA}.
\item \bold{pattern}. Type: \code{string}. Default: \code{NA}.
\item \bold{type}. Type: \code{text OR email OR url OR password OR tel OR search OR file}. Default: \code{"text"}.
\item \bold{startContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{endContent}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{labelPlacement}. Type: \code{inside OR outside OR outside-left}. Default: \code{"inside"}.
\item \bold{fullWidth}. Type: \code{boolean}. Default: \code{true}.
\item \bold{isClearable}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isRequired}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isReadOnly}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isInvalid}. Type: \code{boolean}. Default: \code{false}.
\item \bold{baseRef}. Type: \code{RefObject<HTMLDivElement>}. Default: \code{NA}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<'base' OR 'label' OR 'inputWrapper' OR 'innerWrapper' OR 'mainWrapper' OR 'input' OR 'clearButton' OR 'helperWrapper' OR 'description' OR 'errorMessage', string>>}. Default: \code{NA}.
}
\itemize{
\item \bold{onChange}. Type: \code{React.ChangeEvent<HTMLInputElement>}. Default: \code{NA}.
\item \bold{onValueChange}. Type: \code{(value: string) => void}. Default: \code{NA}.
\item \bold{onClear}. Type: \code{() => void}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)

ui <- nextui_page(
  div(
    class = "flex gap-1",
    text_input(
      inputId = "text",
      value = "Plop",
      placeholder = "Next UI",
      label = "Text input"
    ),
    textOutput("text_val")
  ),
  spacer(y = 5),
  div(
    class = "flex gap-1",
    numeric_input(
      inputId = "numeric",
      value = 10,
      label = "Numeric input"
    ),
    textOutput("numeric_val")
  ),
  spacer(y = 5),
  div(
    class = "flex gap-1",
    date_input(
      inputId = "date",
      value = "2023-12-11",
      label = "Date input"
    ),
    textOutput("date_val")
  )
)

server <- function(input, output, session) {
  output$text_val <- renderText(input$text)
  output$numeric_val <- renderText(input$numeric)
  output$date_val <- renderText(input$date)
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/input}.
}
