% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doc.R, R/inputs.R
\name{tabs}
\alias{tabs}
\alias{update_tabs}
\alias{tab}
\title{tabs}
\usage{
tabs(inputId, ..., value = default_value)

update_tabs(session = shiny::getDefaultReactiveDomain(), inputId, ...)

tab(...)
}
\arguments{
\item{inputId}{ID of the component.}

\item{...}{Props to pass to the component.
The allowed props are listed below in the \bold{Details} section.}

\item{value}{Starting value.}

\item{session}{Object passed as the \code{session} argument to Shiny server.}
}
\value{
An object of class \code{shiny.tag} containing the
necessary configuration and including options such as JavaScript
dependencies to instantiate a HeroUI tabs component.
}
\description{
Tabs organize content into multiple sections and allow users to navigate between them.
}
\details{
\itemize{
\item \bold{children*}. Type: \code{ReactNode OR ((item: T) => ReactElement)}. Default: \code{NA}.
\item \bold{variant}. Type: \code{solid OR bordered OR light OR underlined}. Default: \code{"solid"}.
\item \bold{color}. Type: \code{default OR primary OR secondary OR success OR warning OR danger}. Default: \code{"default"}.
\item \bold{size}. Type: \code{sm OR md OR lg}. Default: \code{"md"}.
\item \bold{radius}. Type: \code{none OR sm OR md OR lg OR full}. Default: \code{NA}.
\item \bold{fullWidth}. Type: \code{boolean}. Default: \code{false}.
\item \bold{items}. Type: \code{Iterable<T>}. Default: \code{NA}.
\item \bold{disabledKeys}. Type: \code{React.Key[]}. Default: \code{NA}.
\item \bold{selectedKey}. Type: \code{React.Key}. Default: \code{NA}.
\item \bold{defaultSelectedKey}. Type: \code{React.Key}. Default: \code{NA}.
\item \bold{shouldSelectOnPressUp}. Type: \code{boolean}. Default: \code{true}.
\item \bold{keyboardActivation}. Type: \code{automatic OR manual}. Default: \code{"automatic"}.
\item \bold{motionProps}. Type: \code{MotionProps}. Default: \code{NA}.
\item \bold{disableCursorAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{isDisabled}. Type: \code{boolean}. Default: \code{false}.
\item \bold{disableAnimation}. Type: \code{boolean}. Default: \code{false}.
\item \bold{classNames}. Type: \code{Partial<Record<"base"OR "tabList"OR "tab"OR "tabContent"OR "cursor" OR "panel" OR "tabWrapper", string>>}. Default: \code{NA}.
\item \bold{placement}. Type: \code{top OR bottom OR start OR end}. Default: \code{"top"}.
\item \bold{isVertical}. Type: \code{boolean}. Default: \code{false}.
\item \bold{destroyInactiveTabPanel}. Type: \code{boolean}. Default: \code{true}.
}
\itemize{
\item \bold{onSelectionChange}. Type: \code{(key: React.Key) => any}. Default: \code{NA}.
}
\itemize{
\item \bold{tabRef}. Type: \code{RefObject<HTMLButtonElement>}. Default: \code{NA}.
\item \bold{children*}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{title}. Type: \code{ReactNode}. Default: \code{NA}.
\item \bold{titleValue}. Type: \code{string}. Default: \code{NA}.
\item \bold{href}. Type: \code{string}. Default: \code{NA}.
\item \bold{target}. Type: \code{HTMLAttributeAnchorTarget}. Default: \code{NA}.
\item \bold{rel}. Type: \code{string}. Default: \code{NA}.
\item \bold{download}. Type: \code{boolean OR string}. Default: \code{NA}.
\item \bold{ping}. Type: \code{string}. Default: \code{NA}.
\item \bold{referrerPolicy}. Type: \code{HTMLAttributeReferrerPolicy}. Default: \code{NA}.
\item \bold{shouldSelectOnPressUp}. Type: \code{boolean}. Default: \code{NA}.
}
}
\examples{
library(shiny)
library(shinyNextUI)

items <- tagList(
  tab(
    key = 1,
    title = div(
      class = "flex items-center gap-1",
      icon("home"),
      "Tab 1"
    ),
    card(
      card_body(
        "Lorem ipsum dolor sit amet, consectetur adipiscing elit,
          sed do eiusmod tempor incididunt ut labore et dolore magna aliqua.
          Ut enim ad minim veniam, quis nostrud exercitation ullamco
          laboris nisi ut aliquip ex ea commodo consequat."
      )
    )
  ),
  tab(
    key = 2,
    title = "Tab 2",
    card(
      card_body(
        "Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris
          nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in
          reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur."
      )
    )
  ),
  tab(
    key = 3,
    title = "Tab 3",
    card(
      card_body(
        "Excepteur sint occaecat cupidatat non proident, sunt in culpa qui
          officia deserunt mollit anim id est laborum."
      )
    )
  )
)

ui <- nextui_page(
  debug_react = TRUE,
  p(class = "font-extrabold text-2xl uppercase", "Simple tabs"),
  tabs(
    inputId = "tabs1",
    disabledKeys = "2",
    items
  ),
  spacer(y = 2),
  select_input(
    "select",
    label = "Tab to select:",
    value = "1",
    select_item(key = 1, value = "1", "1"),
    select_item(key = 3, value = "3", "3")
  ),
  p("Selected tab is:", textOutput("active_tab", inline = TRUE)),
  spacer(y = 5),
  divider(),
  p(class = "font-extrabold text-2xl uppercase", "Tab size"),
  lapply(sizes, function(size) {
    tagList(
      p(class = "", sprintf("Size: \%s", size)),
      tabs(
        inputId = sprintf("tabs-\%s", size),
        size = size,
        items
      )
    )
  }),
  spacer(y = 5),
  divider(),
  p(class = "font-extrabold text-2xl uppercase", "Tab variants"),
  lapply(tabs_variants, function(variant) {
    tagList(
      p(sprintf("Variant: \%s", variant)),
      tabs(
        inputId = sprintf("tabs-\%s", variant),
        variant = variant,
        items
      )
    )
  }),
  spacer(y = 5),
  divider(),
  p(class = "font-extrabold text-2xl uppercase", "Tab color"),
  lapply(colors, function(color) {
    tagList(
      p(class = "", sprintf("Color: \%s", color)),
      tabs(
        inputId = sprintf("tabs-\%s", color),
        variant = "bordered",
        color = color,
        items
      )
    )
  })
)

server <- function(input, output, session) {
  output$active_tab <- renderText(input$tabs1)
  observeEvent(input$select, {
    update_tabs(session, inputId = "tabs1", value = input$select)
  })
}

if (interactive() || is_testing()) shinyApp(ui, server)
}
\seealso{
See \url{https://heroui.com/docs/components/tabs}.
}
