% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treatment-thinning.R
\name{silv_treatment_thinning}
\alias{silv_treatment_thinning}
\title{Calculate Forestry Thinning Schemes}
\usage{
silv_treatment_thinning(
  data,
  var,
  diameter,
  ntrees,
  thinning = "below",
  perc = 0.3,
  .groups = NULL
)
}
\arguments{
\item{data}{A data frame, or silviculture::Inventory object. See details.}

\item{var}{A variable used for calculating the thinning. Typically used variables
basal area, number of trees, or volume}

\item{diameter}{Numeric vector with diametric classes}

\item{ntrees}{Numeric vector with the number of trees per hectare of each diametric
class}

\item{thinning}{Charater string specifying the thinning type. Available options
are \code{below} and \code{above}}

\item{perc}{Numeric value between 0 and 1 specifying the percentage of \code{var}
to extract}

\item{.groups}{A character vector with variables to group by (e.g. plot id, tree
species, etc). Ignored when using a \code{silviculture::Inventory} object}
}
\value{
A \code{silviculture::Thinning} object with three items:
\itemize{
\item \strong{data}: the input data with two new columns
\item \strong{group_metrics}: it will include the data from the \code{silviculture::Inventory} object
\item \strong{thinning_opts}: options used for S7 methods
}
}
\description{
Calculates thinning schemes for forest management by selecting trees to extract
based on specified criteria. Supports both thinning from below (removing smaller trees)
and thinning from above (removing larger trees) approaches.
}
\details{
This function implements common silvicultural thinning practices:

\strong{Thinning from below:} Removes trees with the lowest values of the specified
variable. This approach typically removes suppressed, damaged, or poor-quality
trees, mimicking natural mortality processes.

\strong{Thinning from above:} Removes trees with the highest values of the specified
variable. This approach harvests the most valuable trees while leaving smaller
trees to continue growing.

The function calculates which trees to extract based on the ranking of the
specified variable and the desired thinning percentage. When grouping variables
are provided, thinning is calculated separately for each group.

\strong{Using a silviculture::Inventory object}
The result of \code{\link[=silv_summary]{silv_summary()}} can be used as the \code{data} argument. If so, the \code{.groups}
will be taken from this object, and it will keep the previous data in a new S7 object.
}
\examples{
# Get summary of inventory data
inventory <- inventory_samples |>
 silv_summary(
   diameter  = diameter,
   height    = height,
   plot_size = 25,
   .groups   = c('plot_id', 'species')
 )

## Thinning from below removing 30\% of trees based on basal area
silv_treatment_thinning(
  data     = inventory,
  var      = g_ha,
  diameter = dclass,
  ntrees   = ntrees_ha,
  thinning = "below",
  perc     = 0.3
)

## Thinning from above removing 20\% of trees based on basal area
silv_treatment_thinning(
  data     = inventory,
  var      = g_ha,
  diameter = dclass,
  ntrees   = ntrees_ha,
  thinning = "above",
  perc     = 0.2
)
}
\seealso{
\code{\link[=silv_summary]{silv_summary()}}
}
