% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aaa_internal_data_validation.R
\name{.validate_pedigree}
\alias{.validate_pedigree}
\title{Validate Pedigree Object}
\usage{
.validate_pedigree(pedigree, disallow_U_names = FALSE)
}
\arguments{
\item{pedigree}{An object that is expected to be of class \code{ped}.}

\item{disallow_U_names}{A logical flag indicating whether to disallow IDs starting with "U" followed by a digit (e.g., "U1", "U2", ..., "U10") in the pedigree. Default is \code{FALSE}.}
}
\value{
This function does not return a value. It stops execution if the input is not of class \code{ped} or if forbidden names are found when \code{disallow_U_names} is \code{TRUE}.
}
\description{
This internal function checks if the input object is of class \code{ped}. If not, it stops execution with an error message. Additionally, it can check for forbidden names in the pedigree IDs if specified.
}
\examples{
\dontrun{
  pedigree <- create_ped() # Assuming create_ped() returns an object of class 'ped'
  .validate_pedigree(pedigree)
  .validate_pedigree(pedigree, disallow_U_names = TRUE)
}
}
\keyword{internal}
