% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimplaceWrapper.R
\name{initSimplace}
\alias{initSimplace}
\title{Initialisation of Framework}
\usage{
initSimplace(
  InstallationDir = findFirstSimplaceInstallation(),
  WorkDir = paste0(InstallationDir, "simplace_run/simulation/"),
  OutputDir = paste0(InstallationDir, "simplace_run/output/"),
  ProjectsDir = nullString,
  DataDir = nullString,
  additionalClasspaths = c(),
  javaparameters = getOption("java.parameters"),
  force.init = TRUE
)
}
\arguments{
\item{InstallationDir}{directory where simplace_core, simplace_modules and simplace_run are located}

\item{WorkDir}{working directory where solutions, projects and data resides (_WORKDIR_)}

\item{OutputDir}{directory for output (_OUTPUTDIR_)}

\item{ProjectsDir}{optional directory for project data  (_PROJECTSDIR_)}

\item{DataDir}{optional directory for data (_DATADIR_)}

\item{additionalClasspaths}{vector with class paths relative to InstallationDir that are to be added}

\item{javaparameters}{parameters that are passed to the java virtual machine}

\item{force.init}{(re)initialize a running JVM, see \code{\link[rJava]{.jinit}}}
}
\value{
handle to the SimplaceWrapper object
}
\description{
Initializes the JVM and creates the SimplaceWrapper object which 
is used to interact with Simplace.
}
