% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/miscDiagnostics.R
\name{vcov.singleRStaticCountData}
\alias{vcov.singleRStaticCountData}
\title{Obtain covariance matrix estimation}
\usage{
\method{vcov}{singleRStaticCountData}(object, type = c("Fisher", "observedInform"), ...)
}
\arguments{
\item{object}{object of singleRStaticCountData class.}

\item{type}{type of estimate for covariance matrix for now either
expected (Fisher) information matrix or observed information matrix.}

\item{...}{additional arguments for method functions}
}
\value{
A covariance matrix for fitted coefficients, rows and columns of which
correspond to parameters returned by \code{coef} method.
}
\description{
A \code{vcov} method for \code{singleRStaticCountData} class.
}
\details{
\loadmathjax

Returns a estimated covariance matrix for model coefficients
calculated from analytic hessian or Fisher information matrix usually
utilizing asymptotic effectiveness of maximum likelihood estimates.
Covariance type is taken from control parameter that have been provided
on call that created \code{object} if arguments \code{type} was not specified.
}
\seealso{
\code{\link[=vcovHC.singleRStaticCountData]{vcovHC.singleRStaticCountData()}} \code{\link[sandwich:sandwich]{sandwich::sandwich()}}
}
