% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_plot.R
\name{plot.sits_accuracy}
\alias{plot.sits_accuracy}
\title{Plot confusion matrix}
\usage{
\method{plot}{sits_accuracy}(x, y, ..., type = "confusion_matrix")
}
\arguments{
\item{x}{Object of class "plot.sits_accuracy".}

\item{y}{Ignored.}

\item{...}{Further specifications for \link{plot}.}

\item{type}{Type of plot (either "confusion_matrix"
or "metrics")}
}
\value{
Called for side  package
                     containing color bars showing the confusion
                     between classes.
}
\description{
Plot a table with informations about the confusion matrix or the accuracy metrics
}
\examples{
if (sits_run_examples()) {
    # select a set of samples
    samples <- samples_modis_ndvi
    # index samples to split train/test
    samples[["sample_idx"]] <- 1:nrow(samples)
    # select training data
    train_data <- sits_sample(samples, frac = 0.8)
    # select test data
    sel <- !(samples[["sample_idx"]]
             \%in\% train_data[["sample_idx"]])
    test_data <- samples[sel, ]
    # compute a random forest model
    rfor_model <- sits_train(train_data, sits_rfor())
    # classify training points
    points_class <- sits_classify(
        data = test_data, ml_model = rfor_model
    )
    # calculate accuracy
    acc <- sits_accuracy(points_class)
    # plot accuracy
    plot(acc)
}
}
\author{
Gilberto Camara \email{gilberto.camara@inpe.br}
}
