% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bucket.R
\name{aws_bucket_upload}
\alias{aws_bucket_upload}
\title{Upload a folder of files to create an S3 bucket}
\usage{
aws_bucket_upload(
  path,
  bucket,
  max_batch = fs::fs_bytes("100MB"),
  force = FALSE,
  ...
)
}
\arguments{
\item{path}{(character) local path to a directory. required}

\item{bucket}{(character) bucket name. required}

\item{max_batch}{(fs_bytes) maximum batch size being uploaded with each
multipart}

\item{force}{(logical) force deletion without going through the prompt.
default: \code{FALSE}. Should only be set to \code{TRUE} when required for
non-interactive use.}

\item{...}{named parameters passed on to \code{\link[s3fs:upload]{s3fs::s3_dir_upload()}}}
}
\value{
the s3 format path of the bucket uploaded to
}
\description{
Upload a folder of files to create an S3 bucket
}
\details{
To upload individual files see \code{\link[=aws_file_upload]{aws_file_upload()}}
}
\note{
Requires the env var \code{AWS_REGION}. This function prompts you to make
sure that you want to delete the bucket.
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(fs)
tdir <- path(tempdir(), "apples")
dir.create(tdir)
tfiles <- replicate(n = 10, file_temp(tmp_dir = tdir, ext = ".txt"))
invisible(lapply(tfiles, function(x) write.csv(mtcars, x)))

bucket_name <- random_bucket()
if (!aws_bucket_exists(bucket_name)) aws_bucket_create(bucket_name)
aws_bucket_upload(path = tdir, bucket = bucket_name)
aws_bucket_list_objects(bucket_name)

# cleanup
objs <- aws_bucket_list_objects(bucket_name)
aws_file_delete(objs$uri)
aws_bucket_list_objects(bucket_name)
aws_bucket_delete(bucket_name, force = TRUE)
aws_bucket_exists(bucket_name)
\dontshow{\}) # examplesIf}
}
\seealso{
Other buckets: 
\code{\link{aws_bucket_create}()},
\code{\link{aws_bucket_delete}()},
\code{\link{aws_bucket_download}()},
\code{\link{aws_bucket_exists}()},
\code{\link{aws_bucket_list_objects}()},
\code{\link{aws_bucket_tree}()},
\code{\link{aws_buckets}()},
\code{\link{six_bucket_delete}()},
\code{\link{six_bucket_upload}()}
}
\concept{buckets}
