% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/files.R
\name{aws_file_delete}
\alias{aws_file_delete}
\title{Delete a file}
\usage{
aws_file_delete(remote_path, ...)
}
\arguments{
\item{remote_path}{(character) one or more remote S3 paths. required}

\item{...}{named parameters passed on to
\href{https://www.paws-r-sdk.com/docs/s3_delete_object/}{delete_object}}
}
\value{
\code{NULL} invisibly
}
\description{
Delete a file
}
\examples{
\dontshow{if (aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create a file
bucket <- random_bucket()
aws_bucket_create(bucket)
tfile <- tempfile()
cat("Hello World!\n", file = tfile)
aws_file_upload(path = tfile, remote_path = s3_path(bucket))

# delete the file
aws_file_delete(s3_path(bucket, basename(tfile)))

# file does not exist - no error is raised
aws_file_delete(s3_path(bucket, "TESTING123"))

# Cleanup
six_bucket_delete(bucket, force = TRUE)
\dontshow{\}) # examplesIf}
}
\seealso{
Other files: 
\code{\link{aws_file_attr}()},
\code{\link{aws_file_copy}()},
\code{\link{aws_file_download}()},
\code{\link{aws_file_exists}()},
\code{\link{aws_file_rename}()},
\code{\link{aws_file_upload}()},
\code{\link{six_file_upload}()}
}
\concept{files}
