% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpc_security_groups.R
\name{aws_vpc_sec_group_rules_mod}
\alias{aws_vpc_sec_group_rules_mod}
\title{Modify security group rules}
\usage{
aws_vpc_sec_group_rules_mod(id, rules, ...)
}
\arguments{
\item{id}{(character) security group id. required}

\item{rules}{list of rules to add/modify on the security group \code{id}.
required}

\item{...}{named parameters passed on to \href{https://www.paws-r-sdk.com/docs/ec2_modify_security_group_rules/}{modify_security_group_rules}}
}
\value{
list. if successful then \code{list(Return=TRUE)}
}
\description{
Modify security group rules
}
\examples{
\dontshow{if (interactive() && aws_has_creds()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create a security group
a_grp_name <- random_string("vpcsecgroup")
x <- aws_vpc_security_group_create(name = a_grp_name)
x

# add an inbound rule
my_rule <- aws_vpc_security_group_ingress(
  id = x$GroupId,
  ip_permissions = ip_permissions_generator("mariadb")
)
my_rule

# modify the rule
rule_id <- my_rule$SecurityGroupRules[[1]]$SecurityGroupRuleId
fields_to_keep <- c(
  "IpProtocol", "FromPort", "ToPort", "CidrIpv4",
  "CidrIpv6", "PrefixListId", "Description"
)
rule_old <- my_rule$SecurityGroupRules[[1]]
rule_new <- rule_old[fields_to_keep]
rule_new$Description <- "Modified description"

aws_vpc_sec_group_rules_mod(
  id = x$GroupId,
  rules = list(
    SecurityGroupRuleId = rule_id,
    SecurityGroupRule = rule_new
  )
)

# cleanup
aws_vpc_security_group_delete(name = a_grp_name)
\dontshow{\}) # examplesIf}
}
\seealso{
Other security groups: 
\code{\link{aws_vpc_security_group}()},
\code{\link{aws_vpc_security_group_create}()},
\code{\link{aws_vpc_security_group_ingress}()},
\code{\link{aws_vpc_security_groups}()},
\code{\link{aws_vpc_sg_with_ingress}()}
}
\concept{security groups}
