% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_imp.R
\name{group_features}
\alias{group_features}
\title{Group Features for Imputation}
\usage{
group_features(
  obj,
  features_df,
  k = NULL,
  ncp = NULL,
  subset = NULL,
  min_group_size = 0,
  seed = NULL
)
}
\arguments{
\item{obj}{A numeric matrix with \strong{samples in rows} and \strong{features in columns}.}

\item{features_df}{A data.frame with exactly two columns: \code{feature_id} and
\code{group}. Maps feature identifiers to their respective groups. No missing
values or duplicate \code{feature_id} values are allowed.}

\item{k}{Integer or \code{NULL}. If specified, prepares parameters for K-NN
imputation with \code{k} neighbors. Cannot be used together with \code{ncp}.}

\item{ncp}{Integer or \code{NULL}. If specified, prepares parameters for PCA
imputation with \code{ncp} principal components. Cannot be used together with
\code{k}.}

\item{subset}{Character vector of column names or integer vector of column
indices specifying which columns to impute.}

\item{min_group_size}{Integer (default 0). Minimum number of features per
group. If a group has fewer features, additional features are randomly
sampled from remaining columns to meet this threshold.}

\item{seed}{Numeric or \code{NULL}. Random seed for reproducibility when sampling
for \code{min_group_size} padding.}
}
\value{
A \code{tibble::tibble()} with columns:
\itemize{
\item \strong{features}: A list-column containing character vectors of feature column
names to impute
\item \strong{aux}: A list-column containing character vectors of auxiliary
column names used for imputation but not imputed themselves. Omitted if all
elements are \code{NULL}
\item \strong{parameters}: A list-column containing group-specific parameters if \code{k}
or \code{ncp} are specified
}
}
\description{
Groups matrix columns (features) based on a provided grouping data.frame,
optionally preparing parameters for K-NN or PCA imputation. This function
organizes features into groups, handles imputation of only a subset of features,
and can pad groups to meet a minimum size.
}
\examples{
sim_obj <- sim_mat(perc_col_NA = 1)

obj <- t(sim_obj$input)
obj_meta <- sim_obj$group_feature

# group `obj` based on the metadata
head(obj_meta)

# create `group_df` which can then be used for `group_imp`. We can specify
# `k` for K-NN imputation and subset here as well.
group_df <- group_features(
  obj,
  obj_meta,
  subset = sample(obj_meta$feature_id, size = 10),
  k = 10
)
group_df

imputed_obj <- group_imp(obj, group_df)
imputed_obj

}
\seealso{
\code{\link[=group_imp]{group_imp()}}
}
