% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphs.R
\name{as_adj_def}
\alias{as_adj_def}
\title{Create an adjacency matrix from a multigraph according to the definition}
\usage{
as_adj_def(g, ...)
}
\arguments{
\item{g}{the graph (an igraph object)}

\item{...}{additional arguments to be passed to the igraph function
\code{as_adj}}
}
\value{
Adjacency matrix for graph \code{g}
}
\description{
Create an adjacency matrix using the definition, i.e. an entry equals 1 if
there is an edge from the vertex in the column to the vertex in the row, and
cycles are counted twice.
}
\examples{
g=igraph::graph_from_literal(1-2,2-2:3:3:4,3-4:5:6,5-1:1:1,6-6,simplify=FALSE)
as_adj_def(g)
}
