% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elliptic.zones.R
\name{elliptic.zones}
\alias{elliptic.zones}
\title{Determine zones for \code{elliptic.test}}
\usage{
elliptic.zones(
  coords,
  pop,
  ubpop = 0.5,
  shape = c(1, 1.5, 2, 3, 4, 5),
  nangle = c(1, 4, 6, 9, 12, 15)
)
}
\arguments{
\item{coords}{An \eqn{n \times 2} matrix of centroid
coordinates for the regions in the form (x, y) or
(longitude, latitude) is using great circle distance.}

\item{pop}{The population size associated with each
region.}

\item{ubpop}{The upperbound of the proportion of the
total population to consider for a cluster.}

\item{shape}{The ratios of the major and minor axes of
the desired ellipses.}

\item{nangle}{The number of angles (between 0 and 180) to
consider for each shape.}
}
\value{
A list with all distinct zones, the associated
shape parameters, and the associated angle parameters.
}
\description{
\code{elliptic.zones} constructs the elliptical zones
for \code{\link{elliptic.test}}.
}
\examples{
\dontrun{
data(nydf)
coords <- with(nydf, cbind(longitude, latitude))
out <- elliptic.zones(
  coords = coords, pop = nydf$pop,
  shape = 1.5, nangle = 4
)
}

}
\references{
Kulldorff, M., Huang, L., Pickle,
L. and Duczmal, L. (2006) An elliptic spatial scan
statistic. Statististics in Medicine, 25:3929-3943.
<doi:10.1002/sim.2490>
}
