% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sm_statBlandAlt.R
\name{sm_statBlandAlt}
\alias{sm_statBlandAlt}
\title{Statistics for a Bland-Altman plot}
\usage{
sm_statBlandAlt(first, second)
}
\arguments{
\item{first}{Data from the first repetition/session}

\item{second}{Data from the second repetition/session}
}
\value{
A list is returned, which has all numerical results that are relevant to drawing a Bland-Altman plot.
}
\description{
Bland-Altman plot is drawn to
show measurement variability/reliabiilty of a task. This
function requires two paired datasets (same length).
It returns a list of difference (by element), mean,
standard deviation of the difference,
mean difference, upper and lower limits. These values
are necessary to draw a Bland Altman plot.

The list returned from this function can be directly
used as an argument for sm_bland_altman(), which
draws a Bland-Altman plot using ggplot2.

Another output 'data' is a tibble with two columns:
1) Mean across each pair for each element
(ex. a mean of the 1st element
from the first set and 1st element from the second set), 2)
Difference between each pair for every element.
The output 'data' should be used as a argument for data in ggplot()
when plotting.
}
\examples{
library(smplot2)
library(tibble)

first <- rnorm(20)
second <- rnorm(20)
df <- as_tibble(cbind(first,second)) # requires library(tidyverse)
sm_statBlandAlt(df$first, df$second)

}
