% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ssvd.als.R
\name{Ssvd.als}
\alias{Ssvd.als}
\title{rdname softImpute-internal}
\usage{
Ssvd.als(
  x,
  J = 2,
  thresh = 1e-05,
  lambda = 0,
  maxit = 100,
  trace.it = FALSE,
  warm.start = NULL,
  final.svd = TRUE
)
}
\arguments{
\item{x}{An m by n matrix with NAs. For large matrices can be of class
\code{"Incomplete"}, in which case the missing values are represented as
pseudo zeros leading to dramatic storage reduction. \code{x} can have been
centered and scaled via \code{biScale}, and this information is carried
along with the solution.}

\item{J}{Trevor to document this param}

\item{thresh}{convergence threshold, measured as the relative change in the
Frobenius norm between two successive estimates.}

\item{lambda}{nuclear-norm regularization parameter. If \code{lambda=0}, the
algorithm reverts to "hardImpute", for which convergence is typically
slower, and to local minimum. Ideally \code{lambda} should be chosen so that
the solution reached has rank slightly less than \code{rank.max}. See also
\code{lambda0()} for computing the smallest \code{lambda} with a zero
solution.}

\item{maxit}{maximum number of iterations.}

\item{trace.it}{with \code{trace.it=TRUE}, convergence progress is reported.}

\item{warm.start}{an svd object can be supplied as a warm start. This is
particularly useful when constructing a path of solutions with decreasing
values of \code{lambda} and increasing \code{rank.max}. The previous
solution can be provided directly as a warm start for the next.}

\item{final.svd}{only applicable to \code{type="als"}. The alternating
ridge-regressions do not lead to exact zeros. With the default
\code{final.svd=TRUE}, at the final iteration, a one step unregularized
iteration is performed, followed by soft-thresholding of the singular
values, leading to hard zeros.}
}
\description{
rdname softImpute-internal
}
