% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sourcoise_status.R
\name{sourcoise_status}
\alias{sourcoise_status}
\title{Cache status of sourcoise}
\usage{
sourcoise_status(short = TRUE, quiet = TRUE, root = NULL, prune = TRUE)
}
\arguments{
\item{short}{(boolean) (deafault \code{TRUE}) return a simplified tibble}

\item{quiet}{(boolean) (default \code{TRUE}) no messages during execution}

\item{root}{(string) (default \code{NULL}) force root to a defined path, advanced and not recommanded use}

\item{prune}{(boolean) (default \code{TRUE}) clean up status to display only on relevant cache. However, does not clean other cache files.}
}
\value{
tibble of cached files (see details for structure)
}
\description{
Given the current project, \code{soucoise_status()} collects all information about cache (could be project level, file level)
and return a tibble with this data.
}
\details{
\code{sourcoise_status()} reflects what is on the disk (and results indeed from a scan of all cached files and their metadatas).
So modifying the result of \code{sourcoise_status()} can produce complex bugs when it is passed to \code{sourcoise_refresh()} or \code{sourcoise_clean()}.

Data returned is:
\itemize{
\item \code{src}: path to the source file (r script)
\item \code{date}: last execution date
\item \code{valid}: is cache valid ?
\item \code{uid}: id of user
\item \code{index}: index of cache
\item \code{timing}: last execution timing
\item \code{size}: size of the R object(s) returned
\item \code{lapse}: periodic refresh trigger
\item \code{wd}: wd setting for execution of r script
\item \code{args}: arguments passed to R script
\item \code{json_file}: path to the file keeping cache information
\item \code{qmd_file}: list of path to qmd files calling this script (relevant only for quarto projects)
\item \code{src_in}: localisation of cache option
\item \code{data_file}: path to data cached
\item \code{data_date}: date and time of last save of data
\item \code{log_file}: path to log file, if logging activated
\item \code{root}: path to the project root, used as reference for all paths
\item \code{scr_hash}: hash of the source file
\item \code{track_hash}: hash of the tracked files, if any
\item \code{track}: list of files tracked
\item \code{args_hash}: hash of arguments
\item \code{data_hash}: hash of data cached
}
}
\examples{
\dontshow{if (rlang::is_installed("insee")) withAutoprint(\{ # examplesIf}
dir <- tempdir()
set_sourcoise_root(dir)
fs::file_copy(
    fs::path_package("sourcoise", "some_data.R"),
    dir,
    overwrite = TRUE)
# Force execution
data <- sourcoise("some_data.R", force_exec = TRUE)
# status returns the cache status
sourcoise_status()
\dontshow{\}) # examplesIf}
}
\seealso{
Other sourcoise: 
\code{\link{sourcoise}()},
\code{\link{sourcoise_clear}()},
\code{\link{sourcoise_clear_all}()},
\code{\link{sourcoise_refresh}()},
\code{\link{sourcoise_reset}()}
}
\concept{sourcoise}
