% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change.R
\name{sourcoise_lapse}
\alias{sourcoise_lapse}
\title{Change Cache Lapse Policy}
\usage{
sourcoise_lapse(path, lapse = "never", root = getOption("sourcoise.root"))
}
\arguments{
\item{path}{Character string specifying the file path whose cache metadata
should be updated.}

\item{lapse}{Character string specifying the lapse policy. Default is "never".
Common values include "never", "daily", "weekly", or custom time periods.}

\item{root}{Character string specifying the root directory for the cache.
Defaults to \code{getOption("sourcoise.root")}.}
}
\value{
Invisibly returns the results of writing metadata for each updated
cache entry. Returns a message string if no files are found or no changes
are needed.
}
\description{
Updates the lapse policy metadata for cached files associated with a given
path. The lapse policy determines when cached results should expire.
}
\details{
The function locates all cache entries for the specified path, filters to
the most recent entry for each argument hash, and updates the lapse policy
metadata only for entries where the current lapse value differs from the
specified value.
}
\examples{
\dontrun{
# Set cache to expire daily
sourcoise_lapse("scripts/analysis.R", lapse = "daily")

# Set cache to never expire (default)
sourcoise_lapse("scripts/model.R", lapse = "never")
}
}
