% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/span_py.R
\name{span_py}
\alias{span_py}
\title{Pesaran–Yamagata Alpha Spanning Test (2024)}
\usage{
span_py(R1, R2)
}
\arguments{
\item{R1}{Numeric matrix of benchmark returns, dimension \eqn{T \times K}.}

\item{R2}{Numeric matrix of test-asset returns, dimension \eqn{T \times N}.}
}
\value{
A named list with components:
\describe{
  \item{\code{pval}}{P-value under the standard normal reference distribution.}
  \item{\code{stat}}{Standardized test statistic.}
  \item{\code{H0}}{Null hypothesis description, \code{"alpha = 0"}.}
}
}
\description{
Implements the Pesaran–Yamagata test for the joint null that all intercepts
are zero in a multi-factor spanning regression with possible cross-sectional
dependence across test assets.
}
\details{
The null hypothesis is that all intercepts are zero (\eqn{\alpha = 0}), meaning
the benchmark assets span the expected returns of the test assets. The statistic
adjusts for cross-sectional dependence via the residual covariance and has an
asymptotic \eqn{\mathcal{N}(0,1)} reference under large \eqn{T,N}. Finite-sample
safeguards require \eqn{T-K-1 > 4}.
}
\examples{
set.seed(123)
R1 <- matrix(rnorm(300), 100, 3)  # benchmarks: T=100, K=3
R2 <- matrix(rnorm(200), 100, 2)  # tests:      T=100, N=2
out <- span_py(R1, R2)
out$pval; out$stat; out$H0

}
\references{
\insertRef{PesaranYamagata2024}{spantest}
}
\seealso{
Other Alpha Spanning Tests: 
\code{\link{span_bj}()},
\code{\link{span_f1}()},
\code{\link{span_gl_a}()},
\code{\link{span_grs}()}
}
\concept{Alpha Spanning Tests}
