% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aspline.downscale.R
\name{aspline.downscale}
\alias{aspline.downscale}
\title{Raster Downscale using adaptive regression splines}
\usage{
aspline.downscale(
  x,
  y,
  add.coords = TRUE,
  keep.model = FALSE,
  grid.search = FALSE,
  plot = FALSE,
  ...
)
}
\arguments{
\item{x}{A terra SpatRaster object representing independent variable(s)}

\item{y}{A terra SpatRaster object representing dependent variable}

\item{add.coords}{(FALSE/TRUE) Add spatial coordinates to model}

\item{keep.model}{(FALSE/TRUE) Keep MARS model (earth class object)}

\item{grid.search}{(FALSE/TRUE) perform a hyper-parameter grid se}

\item{plot}{(FALSE/TRUE) Plot results}

\item{...}{Additional arguments passed to earth}
}
\value{
A list object containing:
\itemize{
\item downscale         Downscaled terra SpatRaster object
\item GCV Generalized   Cross Validation (GCV)
\item GRSq              Estimate of the predictive power
\item RSS               Residual sum-of-squares (RSS)
\item RSq               R-square
\item model             earth MARS model object (if keep.model = TRUE)
}
}
\description{
Downscales a raster to a higher resolution raster multivariate adaptive
regression splines (MARS).
}
\details{
This function uses Multivariate Adaptive Regression Splines, to downscale a raster based
on higher-resolution or more detailed raster data specified as covariate(s). This is similar
to the raster.downsample function which uses a robust regression and is a frequentest model for
fitting linear asymptotic relationships whereas, this approach is for fitting nonparametric
functions and should be used when the distributional relationship are complex/nonlinear.
Using add.coords adds spatial coordinates to the model, including creating the associated
rasters for prediction.
}
\examples{
\donttest{
if (require(geodata, quietly = TRUE)) {
library(terra)
library(geodata)

# Download example data (requires geodata package)
  elev <- elevation_30s(country="SWZ",  path=tempdir())
    slp <- terrain(elev, v="slope")
	  x <- c(elev,slp)
        names(x) <- c("elev","slope")
  tmax <- worldclim_country(country="SWZ", var="tmax", 
                                     path=tempdir())
    tmax <- crop(tmax[[1]], ext(elev))
	  names(tmax) <- "tmax"
	  
tmax.ds <- aspline.downscale(x, tmax, add.coords=TRUE, keep.model=TRUE)
  plot(tmax.ds$model) 

  # plot prediction and parameters	
  opar <- par(no.readonly=TRUE)
    par(mfrow=c(2,2))
      plot(tmax, main="Original Temp max")
      plot(x[[1]], main="elevation")
      plot(x[[2]], main="slope")
      plot(tmax.ds$downscale, main="Downscaled Temp max")
  par(opar)

} else { 
  cat("Please install geodata package to run example", "\n")
}
}

}
\references{
Friedman (1991) Multivariate Adaptive Regression Splines (with discussion)
Annals of Statistics 19(1):1–141
}
\author{
Jeffrey S. Evans  \href{mailto:jeffrey_evans@tnc.org}{jeffrey_evans@tnc.org}
}
