% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_range.R
\name{compute_lowCurve}
\alias{compute_lowCurve}
\title{Compute loess curves for smoothing matrix}
\usage{
compute_lowCurve(S, D, newd, cl = NULL, span = 0.1)
}
\arguments{
\item{S}{Smoothing matrix, or a subset of columns from a smoothing matrix.}

\item{D}{Distance matrix, or a subset of columns from a distance matrix.}

\item{newd}{Distances to use for loess prediction.}

\item{cl}{Cluster object, or number of cluster instances to create. Defaults to no parallelization.}

\item{span}{Passed to \code{\link{fitLoess}}}
}
\value{
List with three elements: \eqn{n}-by-\eqn{N} matrix, where \eqn{n} is the length of \code{newd} and \eqn{N} is the number of columns in \code{S}; a vector of length \eqn{n} giving the median curve value; a vector of length \eqn{n} giving the mean curve value.
}
\description{
Calculates a loess curve for the smoothing matrix entries, as a function of distance between points.
}
\details{
For each column in \code{S}, a loess curve is fit to the values as a function of the distances between points, which are taken from the columns of \code{D}. Thus, the order of rows and columns in \code{S} should match the order of rows and columns in \code{D}.
For a large number of locations, this procedure may be somewhat slow. The \code{cl} argument can be used to parallelize the operation using \code{\link[parallel]{clusterMap}}.
}
\examples{

xloc <- runif(n=100, min=0, max=10)
X <- splines::ns(x=xloc, df=4, intercept=TRUE)
S <- computeS(X)
d <- as.matrix(dist(xloc))
xplot <- 0:10
lC <- compute_lowCurve(S, D=d, newd=xplot)
matplot(xplot, lC$SCurve, type="l", col="black")
points(xplot, lC$SCurveMedian, type="l", col="red")
}
\seealso{
\code{\link{computeS}} \code{\link{fitLoess}}
}
