% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spect.R
\name{spect_train}
\alias{spect_train}
\title{Generates a trained caret model using the given primary binary classification. Optionally
generates a stacked ensemble model if a list of base learners is supplied.}
\usage{
spect_train(
  test_prop = 0.2,
  censor_type = "half",
  bin_slices = 10,
  method = "repeatedcv",
  resampling_number = 10,
  kfold_repeats = 3,
  model_algorithm,
  base_learner_list = list(),
  metric = "Kappa",
  rng_seed = 42,
  use_parallel = TRUE,
  cores = 0,
  modeling_data,
  event_indicator_var,
  survival_time_var,
  obs_window
)
}
\arguments{
\item{test_prop}{optional proportion of the data set to reserve for testing}

\item{censor_type}{optional method used to determine censorship in a given bin - may be "half", "prev" or "same". see createDiscreteDat for usage.}

\item{bin_slices}{optional number of intervals to use for predictions.}

\item{method}{optional caret parameter}

\item{resampling_number}{optional for repeated cv}

\item{kfold_repeats}{optional number of folds}

\item{model_algorithm}{primary classification algorithm. Trains a stack-ensemble 
model if `base_learner_list` is supplied, otherwise trains a simple classifier model.}

\item{base_learner_list}{optional list of base learner algorithms}

\item{metric}{optional metric for model calibration}

\item{rng_seed}{optional random number generation seed for reproducibility}

\item{use_parallel}{optioanlly make use of the caret multicore training cluster}

\item{cores}{optioanl number of cores for multicore training. If zero, spect will 
attempt to make a good choice. Note: only relevant if `use_parallel` is set to TRUE, 
otherwise this parameter is ignored.}

\item{modeling_data}{This data set must have one column for time and one column for the 
event indicator. The remaining columns are treated as covariates for modeling.}

\item{event_indicator_var}{The name of the column containing the event indicator 
(values in this column must be zero or one).}

\item{survival_time_var}{The name of the column containing the time variable}

\item{obs_window}{The last time to use for generating person-period data. 
Any event occurring after this time will be administratively censored. In general, 
choosing a time at or near the end of the max observed time will include most events.}
}
\value{
A list containing all intermediate data sets created by `spect_train`, a 
trained caret model object, the following parameters passed to `spect_train`: 
`obs_window`, `survival_time_var`, `event_indicator_var`, `base_learner_list`, 
`bin_slices`, and the bounds of each interval generated by the training data set.
}
\description{
Generates a trained caret model using the given primary binary classification. Optionally
generates a stacked ensemble model if a list of base learners is supplied.
}
\author{
Stephen Abrams, \email{stephen.abrams@louisville.edu}
}
