% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R, R/cir_distr.R
\name{p_Kolmogorov}
\alias{p_Kolmogorov}
\alias{d_Kolmogorov}
\alias{p_cir_stat_Ajne}
\alias{d_cir_stat_Ajne}
\alias{p_cir_stat_Bingham}
\alias{d_cir_stat_Bingham}
\alias{p_cir_stat_Greenwood}
\alias{d_cir_stat_Greenwood}
\alias{p_cir_stat_Gini}
\alias{d_cir_stat_Gini}
\alias{p_cir_stat_Gini_squared}
\alias{d_cir_stat_Gini_squared}
\alias{p_cir_stat_Hodges_Ajne2}
\alias{p_cir_stat_Hodges_Ajne}
\alias{d_cir_stat_Hodges_Ajne}
\alias{p_cir_stat_Kuiper}
\alias{d_cir_stat_Kuiper}
\alias{p_cir_stat_Log_gaps}
\alias{d_cir_stat_Log_gaps}
\alias{p_cir_stat_Max_uncover}
\alias{d_cir_stat_Max_uncover}
\alias{p_cir_stat_Num_uncover}
\alias{d_cir_stat_Num_uncover}
\alias{p_cir_stat_Pycke}
\alias{d_cir_stat_Pycke}
\alias{p_cir_stat_Vacancy}
\alias{d_cir_stat_Vacancy}
\alias{p_cir_stat_Watson}
\alias{d_cir_stat_Watson}
\alias{p_cir_stat_Watson_1976}
\alias{d_cir_stat_Watson_1976}
\alias{p_cir_stat_Range}
\alias{d_cir_stat_Range}
\alias{p_cir_stat_Rao}
\alias{d_cir_stat_Rao}
\alias{p_cir_stat_Rayleigh}
\alias{d_cir_stat_Rayleigh}
\alias{cir_stat_distr}
\alias{p_cir_stat_Bakshaev}
\alias{d_cir_stat_Bakshaev}
\alias{p_cir_stat_Gine_Fn}
\alias{d_cir_stat_Gine_Fn}
\alias{p_cir_stat_Gine_Gn}
\alias{d_cir_stat_Gine_Gn}
\alias{p_cir_stat_Hermans_Rasson}
\alias{d_cir_stat_Hermans_Rasson}
\alias{p_cir_stat_PAD}
\alias{d_cir_stat_PAD}
\alias{p_cir_stat_PCvM}
\alias{d_cir_stat_PCvM}
\alias{p_cir_stat_PRt}
\alias{d_cir_stat_PRt}
\alias{p_cir_stat_Poisson}
\alias{d_cir_stat_Poisson}
\alias{p_cir_stat_Pycke_q}
\alias{d_cir_stat_Pycke_q}
\alias{p_cir_stat_Rothman}
\alias{d_cir_stat_Rothman}
\alias{p_cir_stat_Riesz}
\alias{d_cir_stat_Riesz}
\alias{p_cir_stat_Sobolev}
\alias{d_cir_stat_Sobolev}
\alias{p_cir_stat_Softmax}
\alias{d_cir_stat_Softmax}
\alias{p_cir_stat_Stein}
\alias{d_cir_stat_Stein}
\title{Asymptotic distributions for circular uniformity statistics}
\usage{
p_Kolmogorov(x, K_Kolmogorov = 25L, alternating = TRUE)

d_Kolmogorov(x, K_Kolmogorov = 25L, alternating = TRUE)

p_cir_stat_Ajne(x, K_Ajne = 15L)

d_cir_stat_Ajne(x, K_Ajne = 15L)

p_cir_stat_Bingham(x)

d_cir_stat_Bingham(x)

p_cir_stat_Greenwood(x)

d_cir_stat_Greenwood(x)

p_cir_stat_Gini(x)

d_cir_stat_Gini(x)

p_cir_stat_Gini_squared(x)

d_cir_stat_Gini_squared(x)

p_cir_stat_Hodges_Ajne2(x, n, asymp_std = FALSE)

p_cir_stat_Hodges_Ajne(x, n, exact = TRUE, asymp_std = FALSE)

d_cir_stat_Hodges_Ajne(x, n, exact = TRUE, asymp_std = FALSE)

p_cir_stat_Kuiper(x, n, K_Kuiper = 12L, second_term = TRUE,
  Stephens = FALSE)

d_cir_stat_Kuiper(x, n, K_Kuiper = 12L, second_term = TRUE,
  Stephens = FALSE)

p_cir_stat_Log_gaps(x, abs_val = TRUE)

d_cir_stat_Log_gaps(x, abs_val = TRUE)

p_cir_stat_Max_uncover(x)

d_cir_stat_Max_uncover(x)

p_cir_stat_Num_uncover(x)

d_cir_stat_Num_uncover(x)

p_cir_stat_Pycke(x)

d_cir_stat_Pycke(x)

p_cir_stat_Vacancy(x)

d_cir_stat_Vacancy(x)

p_cir_stat_Watson(x, n = 0L, K_Watson = 25L, Stephens = FALSE)

d_cir_stat_Watson(x, n = 0L, K_Watson = 25L, Stephens = FALSE)

p_cir_stat_Watson_1976(x, K_Watson_1976 = 8L, N = 40L)

d_cir_stat_Watson_1976(x, K_Watson_1976 = 8L)

p_cir_stat_Range(x, n, max_gap = TRUE)

d_cir_stat_Range(x, n, max_gap = TRUE)

p_cir_stat_Rao(x)

d_cir_stat_Rao(x)

p_cir_stat_Rayleigh(x)

d_cir_stat_Rayleigh(x)

p_cir_stat_Bakshaev(x, K_max = 1000, thre = 0, method = "I", ...)

d_cir_stat_Bakshaev(x, K_max = 1000, thre = 0, method = "I", ...)

p_cir_stat_Gine_Fn(x, K_max = 1000, thre = 0, method = "I", ...)

d_cir_stat_Gine_Fn(x, K_max = 1000, thre = 0, method = "I", ...)

p_cir_stat_Gine_Gn(x, K_max = 1000, thre = 0, method = "I", ...)

d_cir_stat_Gine_Gn(x, K_max = 1000, thre = 0, method = "I", ...)

p_cir_stat_Hermans_Rasson(x, K_max = 1000, thre = 0, method = "I", ...)

d_cir_stat_Hermans_Rasson(x, K_max = 1000, thre = 0, method = "I", ...)

p_cir_stat_PAD(x, K_max = 1000, thre = 0, method = "I", ...)

d_cir_stat_PAD(x, K_max = 1000, thre = 0, method = "I", ...)

p_cir_stat_PCvM(x, K_max = 1000, thre = 0, method = "I", ...)

d_cir_stat_PCvM(x, K_max = 1000, thre = 0, method = "I", ...)

p_cir_stat_PRt(x, t = 1/3, K_max = 1000, thre = 0, method = "I", ...)

d_cir_stat_PRt(x, t = 1/3, K_max = 1000, thre = 0, method = "I", ...)

p_cir_stat_Poisson(x, rho = 0.5, K_max = 1000, thre = 0, method = "I",
  ...)

d_cir_stat_Poisson(x, rho = 0.5, K_max = 1000, thre = 0, method = "I",
  ...)

p_cir_stat_Pycke_q(x, q = 0.5, K_max = 1000, thre = 0, method = "I",
  ...)

d_cir_stat_Pycke_q(x, q = 0.5, K_max = 1000, thre = 0, method = "I",
  ...)

p_cir_stat_Rothman(x, t = 1/3, K_max = 1000, thre = 0, method = "I",
  ...)

d_cir_stat_Rothman(x, t = 1/3, K_max = 1000, thre = 0, method = "I",
  ...)

p_cir_stat_Riesz(x, s = 1, K_max = 1000, thre = 0, method = "I", ...)

d_cir_stat_Riesz(x, s = 1, K_max = 1000, thre = 0, method = "I", ...)

p_cir_stat_Sobolev(x, vk2 = c(0, 0, 1), method = "I", ...)

d_cir_stat_Sobolev(x, vk2 = c(0, 0, 1), method = "I", ...)

p_cir_stat_Softmax(x, kappa = 1, K_max = 1000, thre = 0, method = "I",
  ...)

d_cir_stat_Softmax(x, kappa = 1, K_max = 1000, thre = 0, method = "I",
  ...)

p_cir_stat_Stein(x, Stein_K = 10, Stein_cf = FALSE, method = "I", ...)

d_cir_stat_Stein(x, Stein_K = 10, Stein_cf = FALSE, method = "I", ...)
}
\arguments{
\item{x}{a vector of size \code{nx} or a matrix of size \code{c(nx, 1)}.}

\item{K_Kolmogorov, K_Kuiper, K_Watson, K_Watson_1976, K_Ajne}{integer giving
the truncation of the series present in the null asymptotic distributions.
For the Kolmogorov-Smirnov-related series defaults to \code{25}; for the
others series defaults to a smaller number.}

\item{alternating}{use the alternating series expansion for the distribution
of the Kolmogorov-Smirnov statistic? Defaults to \code{TRUE}.}

\item{n}{sample size employed for computing the statistic.}

\item{asymp_std}{compute the distribution associated to the normalized
Hodges-Ajne statistic? Defaults to \code{FALSE}.}

\item{exact}{use the exact distribution for the Hodges-Ajne statistic?
Defaults to \code{TRUE}.}

\item{second_term}{use the second-order series expansion for the
distribution of the Kuiper statistic? Defaults to \code{TRUE}.}

\item{Stephens}{compute Stephens (1970) modification so that the null
distribution of the is less dependent on the sample size?}

\item{abs_val}{compute the distribution associated to the absolute value of
the Darling's log gaps statistic? Defaults to \code{TRUE}.}

\item{N}{number of points used in the
\link[=Gauss_Legen_nodes]{Gauss-Legendre quadrature}. Defaults to \code{40}.}

\item{max_gap}{compute the distribution associated to the maximum gap for
the range statistic? Defaults to \code{TRUE}.}

\item{K_max}{integer giving the truncation of the series that compute the
asymptotic p-value of a Sobolev test. Defaults to \code{1e3}.}

\item{thre}{error threshold for the tail probability given by the
the first terms of the truncated series of a Sobolev test. Defaults to
\code{0} (no further truncation).}

\item{method}{method for approximating the density, distribution, or
quantile function of the weighted sum of chi squared random variables. Must
be \code{"I"} (Imhof), \code{"SW"} (Satterthwaite--Welch), \code{"HBE"}
(Hall--Buckley--Eagleson), or \code{"MC"} (Monte Carlo; only for distribution
or quantile functions). Defaults to \code{"I"}.}

\item{...}{further parameters passed to \code{\link{p_Sobolev}} or
\code{\link{d_Sobolev}} (such as \code{x_tail}).}

\item{t}{\eqn{t} parameter for the Rothman and Cressie tests, a real in
\eqn{(0, 1)}. Defaults to \code{1 / 3}.}

\item{rho}{\eqn{\rho} parameter for the Poisson test, a real in
\eqn{[0, 1)}. Defaults to \code{0.5}.}

\item{q}{\eqn{q} parameter for the Pycke "\eqn{q}-test", a real in
\eqn{(0, 1)}. Defaults to \code{1 / 2}.}

\item{s}{\eqn{s} parameter for the \eqn{s}-Riesz test, a real in
\eqn{(0, 2)}. Defaults to \code{1}.}

\item{vk2}{weights for the finite Sobolev test. A non-negative vector or
matrix. Defaults to \code{c(0, 0, 1)}.}

\item{kappa}{\eqn{\kappa} parameter for the Softmax test, a
non-negative real. Defaults to \code{1}.}

\item{Stein_K}{truncation \eqn{K} parameter for the Stein test, a positive
integer. Defaults to \code{10}.}

\item{Stein_cf}{logical indicating whether to use the characteristic
function in the Stein test. Defaults to \code{FALSE} (moment generating
function).}
}
\value{
A matrix of size \code{c(nx, 1)} with the evaluation of the
distribution or density function at \code{x}.
}
\description{
Computation of the asymptotic null distributions of circular
uniformity statistics.
}
\details{
Descriptions and references for most of the tests are available
in García-Portugués and Verdebout (2018).
}
\examples{
# Ajne
curve(d_cir_stat_Ajne(x), to = 1.5, n = 2e2, ylim = c(0, 4))
curve(p_cir_stat_Ajne(x), n = 2e2, col = 2, add = TRUE)

# Bakshaev
curve(d_cir_stat_Bakshaev(x, method = "HBE"), to = 6, n = 2e2,
      ylim = c(0, 1))
curve(p_cir_stat_Bakshaev(x, method = "HBE"), n = 2e2, add = TRUE, col = 2)

# Bingham
curve(d_cir_stat_Bingham(x), to = 12, n = 2e2, ylim = c(0, 1))
curve(p_cir_stat_Bingham(x), n = 2e2, col = 2, add = TRUE)
# Greenwood
curve(d_cir_stat_Greenwood(x), from = -6, to = 6, n = 2e2, ylim = c(0, 1))
curve(p_cir_stat_Greenwood(x), n = 2e2, col = 2, add = TRUE)

# Hermans-Rasson
curve(p_cir_stat_Hermans_Rasson(x, method = "HBE"), to = 10, n = 2e2,
      ylim = c(0, 1))
curve(d_cir_stat_Hermans_Rasson(x, method = "HBE"), n = 2e2, add = TRUE,
      col = 2)

# Hodges-Ajne
plot(25:45, d_cir_stat_Hodges_Ajne(cbind(25:45), n = 50), type = "h",
     lwd = 2, ylim = c(0, 1))
lines(25:45, p_cir_stat_Hodges_Ajne(cbind(25:45), n = 50), type = "s",
      col = 2)

# Kolmogorov-Smirnov
curve(d_Kolmogorov(x), to = 3, n = 2e2, ylim = c(0, 2))
curve(p_Kolmogorov(x), n = 2e2, col = 2, add = TRUE)

# Kuiper
curve(d_cir_stat_Kuiper(x, n = 50), to = 3, n = 2e2, ylim = c(0, 2))
curve(p_cir_stat_Kuiper(x, n = 50), n = 2e2, col = 2, add = TRUE)

# Kuiper and Watson with Stephens modification
curve(d_cir_stat_Kuiper(x, n = 8, Stephens = TRUE), to = 2.5, n = 2e2,
      ylim = c(0, 10))
curve(d_cir_stat_Watson(x, n = 8, Stephens = TRUE), n = 2e2, lty = 2,
      add = TRUE)
n <- c(10, 20, 30, 40, 50, 100, 500)
col <- rainbow(length(n))
for (i in seq_along(n)) {
  curve(d_cir_stat_Kuiper(x, n = n[i], Stephens = TRUE), n = 2e2,
        col = col[i], add = TRUE)
  curve(d_cir_stat_Watson(x, n = n[i], Stephens = TRUE), n = 2e2,
        col = col[i], lty = 2, add = TRUE)
}

# Maximum uncovered spacing
curve(d_cir_stat_Max_uncover(x), from = -3, to = 6, n = 2e2, ylim = c(0, 1))
curve(p_cir_stat_Max_uncover(x), n = 2e2, col = 2, add = TRUE)

# Number of uncovered spacing
curve(d_cir_stat_Num_uncover(x), from = -4, to = 4, n = 2e2, ylim = c(0, 1))
curve(p_cir_stat_Num_uncover(x), n = 2e2, col = 2, add = TRUE)

# Log gaps
curve(d_cir_stat_Log_gaps(x), from = -1, to = 4, n = 2e2, ylim = c(0, 1))
curve(p_cir_stat_Log_gaps(x), n = 2e2, col = 2, add = TRUE)

# Gine Fn
curve(d_cir_stat_Gine_Fn(x, method = "HBE"), to = 2.5, n = 2e2,
      ylim = c(0, 2))
curve(p_cir_stat_Gine_Fn(x, method = "HBE"), n = 2e2, add = TRUE, col = 2)

# Gine Gn
curve(d_cir_stat_Gine_Gn(x, method = "HBE"), to = 2.5, n = 2e2,
      ylim = c(0, 2))
curve(p_cir_stat_Gine_Gn(x, method = "HBE"), n = 2e2, add = TRUE, col = 2)

# Gini mean difference
curve(d_cir_stat_Gini(x), from = -4, to = 4, n = 2e2, ylim = c(0, 1))
curve(p_cir_stat_Gini(x), n = 2e2, col = 2, add = TRUE)

# Gini mean squared difference
curve(d_cir_stat_Gini_squared(x), from = -10, to = 10, n = 2e2,
      ylim = c(0, 1))
curve(p_cir_stat_Gini_squared(x), n = 2e2, col = 2, add = TRUE)

# PAD
curve(d_cir_stat_PAD(x, method = "HBE"), to = 3, n = 2e2, ylim = c(0, 1.5))
curve(p_cir_stat_PAD(x, method = "HBE"), n = 2e2, add = TRUE, col = 2)

# PCvM
curve(d_cir_stat_PCvM(x, method = "HBE"), to = 4, n = 2e2, ylim = c(0, 2))
curve(p_cir_stat_PCvM(x, method = "HBE"), n = 2e2, add = TRUE, col = 2)

# PRt
curve(d_cir_stat_PRt(x, method = "HBE"), n = 2e2, ylim = c(0, 5))
curve(p_cir_stat_PRt(x, method = "HBE"), n = 2e2, add = TRUE, col = 2)

# Poisson
curve(d_cir_stat_Poisson(x, method = "HBE"), from = -1, to = 5, n = 2e2,
      ylim = c(0, 2))
curve(p_cir_stat_Poisson(x, method = "HBE"), n = 2e2, col = 2, add = TRUE)

# Pycke
curve(d_cir_stat_Pycke(x), from = -5, to = 10, n = 2e2, ylim = c(0, 1))
curve(p_cir_stat_Pycke(x), n = 2e2, col = 2, add = TRUE)

# Pycke q
curve(d_cir_stat_Pycke_q(x, method = "HBE"), to = 15, n = 2e2,
      ylim = c(0, 1))
curve(p_cir_stat_Pycke_q(x, method = "HBE"), n = 2e2, add = TRUE, col = 2)

# Range
curve(d_cir_stat_Range(x, n = 50), to = 2, n = 2e2, ylim = c(0, 4))
curve(p_cir_stat_Range(x, n = 50), n = 2e2, col = 2, add = TRUE)

# Rao
curve(d_cir_stat_Rao(x), from = -6, to = 6, n = 2e2, ylim = c(0, 1))
curve(p_cir_stat_Rao(x), n = 2e2, col = 2, add = TRUE)

# Rayleigh
curve(d_cir_stat_Rayleigh(x), to = 12, n = 2e2, ylim = c(0, 1))
curve(p_cir_stat_Rayleigh(x), n = 2e2, col = 2, add = TRUE)

# Riesz
curve(d_cir_stat_Riesz(x, method = "HBE"), to = 6, n = 2e2,
      ylim = c(0, 1))
curve(p_cir_stat_Riesz(x, method = "HBE"), n = 2e2, add = TRUE, col = 2)

# Rothman
curve(d_cir_stat_Rothman(x, method = "HBE"), n = 2e2, ylim = c(0, 5))
curve(p_cir_stat_Rothman(x, method = "HBE"), n = 2e2, add = TRUE, col = 2)

# Vacancy
curve(d_cir_stat_Vacancy(x), from = -4, to = 4, n = 2e2, ylim = c(0, 1))
curve(p_cir_stat_Vacancy(x), n = 2e2, col = 2, add = TRUE)

# Watson
curve(d_cir_stat_Watson(x), to = 0.5, n = 2e2, ylim = c(0, 15))
curve(p_cir_stat_Watson(x), n = 2e2, col = 2, add = TRUE)

# Watson (1976)
curve(d_cir_stat_Watson_1976(x), to = 1.5, n = 2e2, ylim = c(0, 3))
curve(p_cir_stat_Watson_1976(x), n = 2e2, col = 2, add = TRUE)

# Softmax
curve(d_cir_stat_Softmax(x, method = "HBE"), to = 3, n = 2e2, ylim = c(0, 2))
curve(p_cir_stat_Softmax(x, method = "HBE"), n = 2e2, col = 2, add = TRUE)

# Sobolev
vk2 <- c(0.5, 0)
curve(d_cir_stat_Sobolev(x = x, vk2 = vk2), to = 3, n = 2e2, ylim = c(0, 2))
curve(p_cir_stat_Sobolev(x = x, vk2 = vk2), n = 2e2, col = 2, add = TRUE)
}
\references{
García-Portugués, E. and Verdebout, T. (2018) An overview of
uniformity tests on the hypersphere. \emph{arXiv:1804.00286}.
\doi{10.48550/arXiv.1804.00286}
}
