% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rgpred.R
\name{rgpred}
\alias{rgpred}
\title{Generate spatial predictions using random forest in ranger (RG)}
\usage{
rgpred(
  trainx,
  trainy,
  longlatpredx,
  predx,
  mtry = if (!is.null(trainy) && !is.factor(trainy)) max(floor(ncol(trainx)/3), 1) else
    floor(sqrt(ncol(trainx))),
  num.trees = 500,
  min.node.size = NULL,
  type = "response",
  num.threads = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{trainx}{a dataframe or matrix contains columns of predictor variables.}

\item{trainy}{a vector of response, must have length equal to the number of
rows in trainx.}

\item{longlatpredx}{a dataframe contains longitude and latitude of point
locations (i.e., the centres of grids) to be predicted.}

\item{predx}{a dataframe or matrix contains columns of predictive variables
for the grids to be predicted.}

\item{mtry}{Number of variables to possibly split at in each node. Default is the
(rounded down) square root of the number variables.}

\item{num.trees}{number of trees. By default, 500 is used.}

\item{min.node.size}{Default 1 for classification, 5 for regression.}

\item{type}{Type of prediction. One of 'response', 'se', 'terminalNodes' with
default 'response'. See ranger::predict.ranger for details.}

\item{num.threads}{number of threads. Default is number of CPUs available.}

\item{verbose}{Show computation status and estimated runtime.Default is FALSE.}

\item{...}{other arguments passed on to randomForest.}
}
\value{
A dataframe of longitude, latitude and predictions.
}
\description{
This function is to make spatial predictions using random forest
in ranger.
}
\note{
This function is largely based on rfpred.
}
\examples{
\dontrun{
data(petrel)
data(petrel.grid)
set.seed(1234)
rgpred1 <- rgpred(petrel[, c(1,2, 6:9)], petrel[, 5], petrel.grid[, c(1,2)],
petrel.grid, num.trees = 500)
names(rgpred1)
}

}
\references{
Wright, M. N. & Ziegler, A. (2017). ranger: A Fast Implementation
of Random Forests for High Dimensional Data in C++ and R. J Stat Softw 77:1-17.
http://dx.doi.org/10.18637/jss.v077.i01.
}
\author{
Jin Li
}
