% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootstrap.assemblage.R
\name{bootstrap.assemblage}
\alias{bootstrap.assemblage}
\title{Bootstrap Assemblage of Species}
\usage{
bootstrap.assemblage(f, f0.func, n.boot = 500, ...)
}
\arguments{
\item{f}{a vector of species frequencies where \code{f[i]} is the number of 
species represented by only \code{i} samples.}

\item{f0.func}{function calculating the unobserved number of 
species (\code{f0}).}

\item{n.boot}{number of bootstrap replicates.}

\item{...}{other arguments to \code{f0.func}.}
}
\value{
a list of bootstrap replicates of species frequencies.
}
\description{
Create bootstrap assemblage of species.
}
\references{
Chao, A., N.J. Gotelli, T.C. Hsieh, E.L. Sander, K.H. Ma, 
  R.K. Colwell, and A.M. Ellison. 2014. Rarefaction and extrapolation with
  Hill numbers: a framework for sampling and estimation in species 
  diversity studies. Ecological Monographs 84(1):45-67.
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
