% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spsUtil.R
\name{checkNameSpace}
\alias{checkNameSpace}
\title{check namespace}
\usage{
checkNameSpace(
  packages,
  quietly = FALSE,
  from = "CRAN",
  time_out = 1,
  on_timeout = {
     FALSE
 }
)
}
\arguments{
\item{packages}{vector of strings}

\item{quietly}{bool, give you warning on fail?}

\item{from}{string, where this package is from like, "CRAN", "GitHub", only
for output message display purpose}

\item{time_out}{numeric, how long to wait before reaching the time limit. Sometimes
there are too many pkgs installed and takes too long to scan the whole list.
Set this timeout in seconds to prevent the long waiting.}

\item{on_timeout}{expressions, call back experssions to run when reaches timeout time.
Default is return `FALSE` as indicating
that package is missing (we can't find the package).}
}
\value{
vector of strings, of missing package names, `character(0)` if no missing
}
\description{
Help you to check if you have certain packages and
return missing package names
}
\examples{
checkNameSpace("ggplot2")
checkNameSpace("random_pkg")
checkNameSpace("random_pkg", quietly = TRUE)
}
