% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ash1_wgt.R
\name{ash1_wgt}
\alias{ash1_wgt}
\title{Compute the average shifted histogram (ASH) for one-dimensional weighted data}
\usage{
ash1_wgt(
  x,
  wgt = rep(1, length(x)),
  m = 5,
  nbin = 50,
  ab = NULL,
  support = "Continuous"
)
}
\arguments{
\item{x}{Vector used to estimate the density. \code{NA} values are allowed.}

\item{wgt}{Vector of weights for each observation from a
probability sample. The default assigns equal weights (equal probability).}

\item{m}{Number of empty bins to add to the ends when the range is not
completely specified.  The default is \code{5}.}

\item{nbin}{Number of bins for density estimation.  The default is \code{50}.}

\item{ab}{Optional range for support associated with the density. Both
values may be equal to \code{NA}.  If equal to \code{NA}, then corresponding limit will
be based on \code{nicerange()}. The default is \code{NULL}.}

\item{support}{Type of support.  If equal to \code{"Continuous"}, then data are
from a continuous distribution.  If equal to \code{"Ordinal"}, then data are from
a discrete distribution defined for integers only.  The default is
\code{"Continuous"}.}
}
\value{
List containing the ASH density estimate.  List consists of
  \describe{
    \item{\code{tcen}}{ x-coordinate for center of bin}
    \item{\code{f}}{ y-coordinate for density estimate height}
  }
}
\description{
Calculate the average shifted histogram estimate of a density based on one-dimensional data
  from a survey design with weights.
}
\examples{
x <- rnorm(100, 10, sqrt(10))
wgt <- runif(100, 10, 100)
rslt <- ash1_wgt(x, wgt)
plot(rslt)
}
\references{
Scott, D. W. (1985). "Averaged shifted histograms: effective nonparametric
  density estimators in several dimensions." \emph{The Annals of Statistics} 13(3):
  1024-1040.
}
\author{
Tony Olsen \email{Olsen.tony@epa.gov}
}
