#' Delete query.
#'
#' This class represents an SQL SELECT query.
#' See the function make_delete() to create more easily a QueryDelete object.
#'
#' @examples
#' # Create a simple DELETE query for deleting some old books:
#' where <- StmtWhere$new(ExprBinOp$new(
#'   ExprField$new("year"), "<",
#'   ExprValue$new(2015)
#' ))
#' delete <- QueryDelete$new(StmtDelete$new('books'))
#' delete$add(where)
#'
#' @seealso \code{\link{make_delete}}
#' @import R6
#' @include Query.R
#' @export
QueryDelete <- R6::R6Class("QueryDelete",
  inherit = Query,
  public = list(

    #' @description
    #' Initializer.
    #' @param delete A StmtDelete instance.
    #' @return Nothing.
    initialize = function(delete) {
      chk::chk_is(delete, "StmtDelete")
      super$initialize(c("Delete", "Where?"))
      self$add(delete)
      return(invisible(NULL))
    }
  )
)
