#' SQL From statement.
#'
#' @examples
#' # Example a FROM statement:
#' StmtFrom$new('books')
#'
#' @import R6
#' @import chk
#' @include Statement.R
#' @export
StmtFrom <- R6::R6Class("StmtFrom",
  inherit = Statement,
  public = list(

    #' @description
    #' Initializer.
    #' @param tabl A table name.
    #' @return Nothing.
    initialize = function(tabl) {
      chk::chk_string(tabl)
      private$table <- tabl
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      return(list(
        .from, .spc,
        TokenIdentifier$new(private$table)
      ))
    }
  ),
  private = list(
    table = NULL
  )
)
