% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sshic.R
\name{sshic}
\alias{sshic}
\title{Measurement of Spatial Stratified Heterogeneity Based on Information Consistency for Continuous Variables}
\usage{
sshic(d, s, seed = 42, permutation_number = 999, bin_method = "Sturges")
}
\arguments{
\item{d}{The target variable.}

\item{s}{The stratification.}

\item{seed}{(optional) Random number seed, default is \code{42}.}

\item{permutation_number}{(optional) Number of Random Permutations, default is \code{999}.}

\item{bin_method}{(optional) Histogram binning method for probability density estimation, default is
\code{Sturges}.}
}
\value{
A two-element numerical vector.
}
\description{
Measurement of Spatial Stratified Heterogeneity Based on Information Consistency for Continuous Variables
}
\examples{
\donttest{
# This code may take a bit longer to execute:
baltim = sf::read_sf(system.file("extdata/baltim.gpkg",package = "sshicm"))
sshic(baltim$PRICE,baltim$DWELL)
}
}
