% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssimparser.R
\name{get_ssim_sample}
\alias{get_ssim_sample}
\title{get_ssim_sample}
\usage{
get_ssim_sample(
  datefrom = as.Date("2020-11-01"),
  dateto = as.Date("2020-12-01"),
  season = "W20",
  creadate = Sys.Date()
)
}
\arguments{
\item{datefrom}{First date of the sample.}

\item{dateto}{Last date of the sample.}

\item{season}{IATA season (W20 = Winter 2020).}

\item{creadate}{Creation date. Default today.}
}
\value{
A character vector containing the SSIM sample.
}
\description{
Get a test SSIM file for validation and testing.
}
\examples{
# Get sample
sample_ssim_str <- ssimparser::get_ssim_sample(datefrom = as.Date("2020-11-01"),
dateto = as.Date("2020-12-01"),
season="W20")

# Parse the sample into a data frame
ssim_sample_df <- ssimparser::load_ssim(ssim_file = sample_ssim_str)
head(ssim_sample_df, 10)
}
