% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/starling-package.R
\docType{package}
\name{starling-package}
\alias{starling}
\alias{starling-package}
\title{starling: Link Infectious Disease Cases to Vaccination and Hospitalization Records}
\description{
Facilitates probabilistic record linkage between infectious disease surveillance datasets (notifiable disease registers, outbreak line-lists), vaccination registries, and hospitalization records using methods based on Fellegi and Sunter (1969) \doi{10.1080/01621459.1969.10501049} and Sayers et al. (2016) \doi{10.1093/ije/dyv322}. The package provides core functions for data preparation, linkage, and analysis: clean_the_nest() standardizes variable names and formats across heterogeneous datasets; murmuration() performs machine learning-based record linkage using blocking variables and similarity metrics; molting() deidentifies datasets for secure sharing; homing() re-identifies previously deidentified datasets; plumage() identifies and categorizes comorbidities; and preening() creates analysis-ready variables including age categories and temporal groupings. Designed for epidemiological research linking acute and post-acute disease outcomes to vaccination status and healthcare utilization. Supports multiple linkage scenarios including case-to-vaccination, case-to-hospitalization, and event-based vaccination status determination (e.g., outbreak attendees, flight passengers, exposure site visitors).
}
\author{
\strong{Maintainer}: Nicolas Smoll \email{nrsmoll@gmail.com} (\href{https://orcid.org/0000-0002-6923-9701}{ORCID})

}
\keyword{internal}
