% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{ci.spcor}
\alias{ci.spcor}
\title{Confidence interval for a semipartial correlation}
\usage{
ci.spcor(alpha, cor, r2, n)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor}{estimated semipartial correlation}

\item{r2}{estimated squared multiple correlation in full model}

\item{n}{sample size}
}
\value{
Returns a 1-row matrix. The columns are:
\itemize{
\item Estimate - estimated semipartial correlation (from input)
\item SE - standard error
\item LL - lower limit of the confidence interval
\item UL - upper limit of the confidence interval
}
}
\description{
Computes a Fisher confidence interval for a population semipartial
correlation. This function requires an (unadjusted) estimate of the
squared multiple correlation in the full model that contains the
predictor variable of interest plus all control variables. This
function computes a modified Aloe-Becker confidence interval that uses
n - 3 rather than n in the standard error and also uses a Fisher
transformation of the semipartial correlation.

For more details, see Section 2.7 of Bonett (2021, Volume 2)
}
\examples{
ci.spcor(.05, -.355, .230, 236)

# Should return:
# Estimate      SE      LL      UL
#   -0.355 0.05426 -0.4565 -0.2444
 

}
\references{
\insertRef{Bonett2021}{statpsych}

\insertRef{Aloe2012}{statpsych}
}
