% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/are_dbl_ish.R
\name{are_dbl_ish}
\alias{are_dbl_ish}
\alias{is_dbl_ish}
\alias{are_dbl_ish.character}
\alias{are_dbl_ish.factor}
\alias{are_dbl_ish.default}
\title{Check if an object can be safely coerced to double}
\usage{
are_dbl_ish(x, ...)

is_dbl_ish(x, ...)

\method{are_dbl_ish}{character}(x, ..., coerce_character = TRUE)

\method{are_dbl_ish}{factor}(x, ..., coerce_factor = TRUE)

\method{are_dbl_ish}{default}(x, ..., depth = 1)
}
\arguments{
\item{x}{The object to check.}

\item{...}{Arguments passed to methods.}

\item{coerce_character}{\verb{(length-1 logical)} Should character vectors such as
"1" and "2.0" be considered numeric-ish?}

\item{coerce_factor}{\verb{(length-1 logical)} Should factors with values such as
"1" and "2.0" be considered numeric-ish? Note that this package uses the
character value from the factor, while \code{\link[=as.integer]{as.integer()}} and \code{\link[=as.double]{as.double()}} use
the integer index of the factor.}

\item{depth}{\verb{(length-1 integer)} Current recursion depth. Do not manually
set this parameter.}
}
\value{
\code{are_dbl_ish()} returns a logical vector with the same length as the
input. \code{is_dbl_ish()} returns a \verb{length-1 logical} (\code{TRUE} or \code{FALSE}) for
the entire vector.
}
\description{
\code{are_dbl_ish()} is a vectorized predicate function that checks whether each
element of its input can be safely coerced to a double vector.

\code{is_dbl_ish()} is a scalar predicate function that checks if all elements of
its input can be safely coerced to a double vector.
}
\examples{
are_dbl_ish(c(1.0, 2.2, 3.14))
is_dbl_ish(c(1.0, 2.2, 3.14))

are_dbl_ish(1:3)
is_dbl_ish(1:3)

are_dbl_ish(c("1.1", "2.2", NA))
is_dbl_ish(c("1.1", "2.2", NA))

are_dbl_ish(c("a", "1.0"))
is_dbl_ish(c("a", "1.0"))

are_dbl_ish(list(1, "2.2", "c"))
is_dbl_ish(list(1, "2.2", "c"))

are_dbl_ish(c(1 + 1i, 1 + 0i, NA))
is_dbl_ish(c(1 + 1i, 1 + 0i, NA))
}
