% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{preprocessPredictionData}
\alias{preprocessPredictionData}
\title{Preprocess Covariates for Model Prediction}
\usage{
preprocessPredictionData(input_data, metadata)
}
\arguments{
\item{input_data}{Covariates, provided as either a dataframe or a matrix}

\item{metadata}{List containing information on variables, including train set
categories for categorical variables}
}
\value{
Preprocessed data with categorical variables appropriately handled
}
\description{
Preprocess covariates for use in a \code{ForestDataset} at prediction time.
DataFrames will be preprocessed based on their column
types. Matrices will be passed through assuming all columns are numeric.
}
\examples{
cov_df <- data.frame(x1 = 1:5, x2 = 5:1, x3 = 6:10)
metadata <- list(num_ordered_cat_vars = 0, num_unordered_cat_vars = 0,
                 num_numeric_vars = 3, numeric_vars = c("x1", "x2", "x3"))
X_preprocessed <- preprocessPredictionData(cov_df, metadata)
}
