% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rule.tite.R
\name{plot.rule.tite}
\alias{plot.rule.tite}
\title{Plot Stopping Rule (TITE Method)}
\usage{
\method{plot}{rule.tite}(
  x,
  xlim = c(0, x$n),
  ylim = c(0, max(x$Rule[, 2]) + 1),
  xlab = " Effective Sample Size",
  ylab = "# Events",
  ...
)
}
\arguments{
\item{x}{A \code{rule.tite} object calculated by \code{calc.rule.tite()} function}

\item{xlim}{The x limits (x1, x2) of the plot. Note that x1 > x2 is allowed and leads to a ‘reversed axis’.}

\item{ylim}{The y limits of the plot.}

\item{xlab}{The title for the x axis}

\item{ylab}{The title for the y axis}

\item{...}{Other options to be passed to generic \code{plot} function}
}
\value{
No return value; function solely generates a plot
}
\description{
Display a stopping rule graphically as a curve
}
\examples{
\dontrun{# Binomial Pocock test in 50 patient cohort at 10\% level, expected toxicity probability of 20\%
poc_rule = calc.rule.tite(n=50,p0=0.20,alpha=0.10,type="Pocock")

# Bayesian beta-extended binomial method in 50 patient cohort at 10\% level,
# expected toxicity probability of 20\%
bb_rule = calc.rule.tite(n=50,p0=0.20,alpha=0.10,type="BB",param=c(2,8))

# Plot stopping boundary
plot(poc_rule,col="blue")
lines(bb_rule,col="red")
}
}
