% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_decision_votes.R
\name{get_decision_votes}
\alias{get_decision_votes}
\title{Retreive vote decision for a specified vote}
\usage{
get_decision_votes(voteid = NA, good_manners = 0)
}
\arguments{
\item{voteid}{Character string indicating the id of the vote to request all votes from}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{vote_id} \tab Id of the vote \cr
   \strong{decision_code} \tab General code for decision \cr
   \strong{decision_comment} \tab Comments for the decision \cr
   \strong{decision_number} \tab Decision number \cr
   \strong{decision_reference} \tab Reference for the decision \cr
   \strong{decision_text} \tab Full text of the decision \cr
}
}
\description{
A function for retrieving vote decisions from a specific vote.
Vote data are only available from the 2011-2012 session
}
\examples{
\dontrun{
decision <- get_decision_votes(123)
decision
}
 
}
\seealso{
\link{get_session_decisions} \link{get_proposal_votes} \link{get_vote} \link{get_result_vote}
}
