% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zz_help_files.R
\name{random_strings}
\alias{random_strings}
\title{random_strings}
\usage{
random_strings(N, string_size = 50, charset = "abcdefghijklmnopqrstuvwxyz", 
                      vector_mode = "stringfish")
}
\arguments{
\item{N}{The number of strings to generate}

\item{string_size}{The length of the strings}

\item{charset}{The characters used to generate the random strings (default: abcdefghijklmnopqrstuvwxyz)}

\item{vector_mode}{The type of character vector to generate (either stringfish or normal, default: stringfish)}
}
\value{
A character vector of the random strings
}
\description{
A function that generates random strings
}
\details{
The function uses the PCRE2 library, which is also used internally by R. 
Note: the order of paramters is switched compared to the `gsub` base R function, with subject being first. 
See also: https://www.pcre.org/current/doc/html/pcre2api.html for more documentation on match syntax.
}
\examples{
if(getRversion() >= "3.5.0") {
set.seed(1)
x <- random_strings(1e6, 80, "ACGT", vector_mode = "stringfish")
}
}
\seealso{
gsub
}
