% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/omniphobicity_analysis.R
\name{omniphobicity_analysis}
\alias{omniphobicity_analysis}
\title{Omniphobicity Data Analysis}
\arguments{
\item{contact_data}{A data frame containing at least two numeric columns: 'WCA' and 'OCA'.}

\item{ellipse_level}{A numeric value between 0 and 1 specifying the confidence level for the ellipse in the PCA plot. Default is 0.68.}
}
\value{
A list containing the results of the omniphobicity analysis, including:
\itemize{
  \item \strong{Classification table} summarizing surface categories based on water and oil contact angles.
  \item \strong{Contact angle summary statistics} including minimum, maximum, mean, and standard deviation of WCA and OCA.
  \item \strong{Bar plot} visualizing the distribution of surface classifications.
  \item \strong{Scatter plot} showing the relationship between water and oil contact angles across samples.
  \item \strong{PCA plot} with ellipses and sample scores to visualize clustering among surface types.
  \item \strong{PCA loadings plot} showing contributions of WCA and OCA to the principal components.
  \item \strong{Boxplots} of PC1 and PC2 scores grouped by surface type.
  \item \strong{ANOVA and Tukey HSD test results} for PC1 and PC2 scores across surface types.
  \item \strong{Compact Letter Displays (CLDs)} indicating statistically significant groupings based on post-hoc tests.
}
}
\description{
This function classifies surface wetting behavior based on water contact angle (WCA)
and oil contact angle (OCA) values, then visualizes the results using scatter plots,
bar plots, and Principal Component Analysis (PCA). PCA plots include group ellipses
to show clustering trends, with the ellipse confidence level set by the 'ellipse_level'
parameter (default = 0.68, corresponding to approximately 1 standard deviation).
}
\examples{
# EXAMPLE 1:
WCA = c(151.3, 154.1, 144.5, 143.0, 147.6, 85.2, 60.4, 152.1, 149.8, 148.7, 140.0, 88.0, 65.0,
        152.4, 70.0, 144.33, 150.50, 147.05, 149.35, 145.66, 141.2, 60.1, 92.7, 75.3, 155.0)
OCA = c(145.1, 143.4, 147.6, 139.0, 151.7, 80.3, 49.5, 143.8, 141.1, 143.8, 147.6, 72.5, 40.0,
        143.6, 65.2, 140.10, 141.65, 142.17, 138.84, 138.23, 137.8, 45.6, 91.3, 60.2, 150.2)
contact_data <- data.frame(WCA, OCA)
omniphobicity_analysis(contact_data) # ellipse_level = 0.68 (default unless specified)
omniphobicity_analysis(contact_data, ellipse_level = 0.95)

# EXAMPLE 2:
WCA = c(65.2, 72.1, 58.7, 75.4, 68.9, 70.1, 66.5, 122.3, 135.5,
        140.8, 125.6, 130.2, 115.0, 138.3, 143.0, 127.6, 119.7,
        72.4, 85.3, 79.6, 68.5, 82.9, 76.1, 88.0, 84.2, 110.5,
        97.6, 104.2, 111.3, 120.7, 99.4)
OCA = c(72.6, 75.1, 60.8, 69.4, 80.2, 77.5, 68.3, 120.4, 130.7,
        133.2, 127.5, 123.3, 115.6, 134.1, 125.9, 117.4, 129.0,
        110.2, 103.8, 112.5, 108.4, 115.9, 111.3, 120.0, 106.6,
        72.1, 85.2, 70.3, 78.4, 88.6, 66.0)
contact_data <- data.frame(WCA, OCA)
omniphobicity_analysis(contact_data) # ellipse_level = 0.68 (default unless specified)
omniphobicity_analysis(contact_data, ellipse_level = 0.95)

}
\author{
Paul Angelo C. Manlapaz
}
