% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/github_ls.R
\name{github_ls_single}
\alias{github_ls_single}
\title{List Objects in a Single Folder of a GitHub Repository}
\usage{
github_ls_single(repo = NULL, folder = NULL)
}
\arguments{
\item{repo}{(character) full URL for a GitHub repository (including "github.com")}

\item{folder}{(NULL/character) either \code{NULL} or the name of the folder to list. If \code{NULL}, the top-level contents of the repository will be listed}
}
\value{
(dataframe) two-column dataframe including (1) the names of the contents and (2) the type of each content item (e.g., file/directory/etc.)
}
\description{
Accepts a GitHub repository URL and identifies all files in the specified folder. If no folder is specified, lists top-level repository contents. This function only works on repositories (public or private) to which you have access.
}
\examples{
\dontrun{
# List contents of the top-level of the `supportR` package repository
supportR::github_ls_single(repo = "https://github.com/njlyon0/supportR")
}

}
